/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Trigger;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorConfig;
import org.mobicents.javax.media.mscontrol.resource.ExtendedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaGroupConfig {
    private final ParametersImpl parametersImpl = new ParametersImpl();
    private final Set<Parameter> parameters;
    private final Set<Action> actions;
    private final Set<EventType> eventTypes;
    private final Set<Qualifier> qualifiers;
    private final Set<Trigger> triggers;
    private final Set<Value> values;
    private PlayerConfig playerConfig;
    private RecorderConfig recorderConfig;
    private SignalDetectorConfig sigDetConfig;

    public MediaGroupConfig(boolean clone) {
        this.parameters = new HashSet<Parameter>();
        this.actions = new HashSet<Action>();
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
    }

    public MediaGroupConfig(PlayerConfig playerConfig, RecorderConfig recorderConfig, SignalDetectorConfig sigDetConfig) {
        this.parametersImpl.put(ExtendedParameter.ENDPOINT_LOCAL_NAME, (Object)"/mobicents/media/IVR/$");
        this.parametersImpl.put(MediaObject.MEDIAOBJECT_ID, (Object)Parameters.NO_PARAMETER);
        this.parametersImpl.put(MediaSession.TIMEOUT, (Object)30000);
        this.parameters = new HashSet<Parameter>();
        this.actions = new HashSet<Action>();
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.parameters.addAll(this.parametersImpl.keySet());
        this.init(playerConfig, recorderConfig, sigDetConfig);
    }

    private void init(PlayerConfig playerConfig, RecorderConfig recorderConfig, SignalDetectorConfig sigDetConfig) {
        this.playerConfig = playerConfig;
        if (this.playerConfig != null) {
            this.parameters.addAll(playerConfig.getParameters());
            this.actions.addAll(playerConfig.getActions());
            this.eventTypes.addAll(playerConfig.getEventTypes());
            this.qualifiers.addAll(playerConfig.getQualifiers());
            this.triggers.addAll(playerConfig.getTriggers());
            this.values.addAll(playerConfig.getValues());
        }
        this.recorderConfig = recorderConfig;
        if (this.recorderConfig != null) {
            this.parameters.addAll(recorderConfig.getParameters());
            this.actions.addAll(recorderConfig.getActions());
            this.eventTypes.addAll(recorderConfig.getEventTypes());
            this.qualifiers.addAll(recorderConfig.getQualifiers());
            this.triggers.addAll(recorderConfig.getTriggers());
            this.values.addAll(recorderConfig.getValues());
        }
        this.sigDetConfig = sigDetConfig;
        if (this.sigDetConfig != null) {
            this.parameters.addAll(this.sigDetConfig.getParameters());
            this.actions.addAll(this.sigDetConfig.getActions());
            this.eventTypes.addAll(this.sigDetConfig.getEventTypes());
            this.qualifiers.addAll(this.sigDetConfig.getQualifiers());
            this.triggers.addAll(this.sigDetConfig.getTriggers());
            this.values.addAll(this.sigDetConfig.getValues());
        }
    }

    public ParametersImpl getParametersImpl() {
        ParametersImpl newparams = new ParametersImpl();
        newparams.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parametersImpl));
        if (this.playerConfig != null) {
            newparams.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.playerConfig.getParametersImpl()));
        }
        if (this.recorderConfig != null) {
            newparams.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.recorderConfig.getParametersImpl()));
        }
        if (this.sigDetConfig != null) {
            newparams.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.sigDetConfig.getParametersImpl()));
        }
        return newparams;
    }

    public void setParametersImpl(Parameters params) {
        for (Parameter p : params.keySet()) {
            for (Parameter actual : this.parametersImpl.keySet()) {
                if (p != actual) continue;
                this.parametersImpl.put(actual, params.get((Object)actual));
            }
        }
        if (this.playerConfig != null) {
            this.playerConfig.setParametersImpl(params);
        }
        if (this.recorderConfig != null) {
            this.recorderConfig.setParametersImpl(params);
        }
        if (this.sigDetConfig != null) {
            this.sigDetConfig.setParametersImpl(params);
        }
    }

    public Set<Parameter> getParameters() {
        return this.parameters;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Set<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public Set<Value> getValues() {
        return this.values;
    }

    public PlayerConfig getPlayerConfig() {
        return this.playerConfig;
    }

    public RecorderConfig getRecorderConfig() {
        return this.recorderConfig;
    }

    public SignalDetectorConfig getSigDetConfig() {
        return this.sigDetConfig;
    }

    public MediaGroupConfig createCustomizedClone(Parameters params) {
        MediaGroupConfig mgCongClone = new MediaGroupConfig(true);
        mgCongClone.parametersImpl.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parametersImpl));
        PlayerConfig plCfClone = null;
        if (this.playerConfig != null) {
            plCfClone = this.playerConfig.createCustomizedClone(params);
        }
        RecorderConfig reCfClone = null;
        if (this.recorderConfig != null) {
            reCfClone = this.recorderConfig.createCustomizedClone(params);
        }
        SignalDetectorConfig sedDetCfClone = null;
        if (this.sigDetConfig != null) {
            sedDetCfClone = this.sigDetConfig.createCustomizedClone(params);
        }
        mgCongClone.init(plCfClone, reCfClone, sedDetCfClone);
        if (params != null && params != Parameters.NO_PARAMETER) {
            for (Parameter p : mgCongClone.parametersImpl.keySet()) {
                for (Parameter pArg : params.keySet()) {
                    if (p != pArg) continue;
                    mgCongClone.parametersImpl.put(pArg, params.get((Object)pArg));
                }
            }
        }
        return mgCongClone;
    }
}

