/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.enums.EventTypeEnum;
import javax.media.mscontrol.resource.enums.ParameterEnum;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaGroupRequestTx
implements Runnable,
JainMgcpExtendedListener {
    private static Logger logger = Logger.getLogger(MediaGroupRequestTx.class);
    private int tx = -1;
    private int startOffset = 0;
    private int maxDuration = 0;
    private Qualifier qualifier = PlayerEvent.END_OF_PLAY_LIST;
    private boolean update = true;
    private final LinkedList<URI> uriList;
    private MediaGroupImpl mediaGroup;
    private MgcpWrapper mgcpWrapper;
    private boolean dtmf;

    public MediaGroupRequestTx(MgcpWrapper mgcpWrapper, MediaGroupImpl mg, LinkedList<URI> uriList, int startOffset, int maxDuration, boolean update, boolean dtmf) {
        this.mediaGroup = mg;
        this.startOffset = startOffset;
        this.maxDuration = maxDuration;
        this.update = update;
        this.uriList = uriList;
        this.mgcpWrapper = mgcpWrapper;
        this.dtmf = dtmf;
    }

    private void playNextFile(PlayerEvent anEvent) {
        URI uri = this.uriList.peek();
        if (uri != null) {
            this.run();
        } else {
            if (this.update) {
                this.mediaGroup.getPlayerExt().updateState();
                this.mediaGroup.getPlayerExt().update(anEvent);
            }
            this.mediaGroup.getPlayerExt().executeNextTx();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        this.tx = this.mgcpWrapper.getUniqueTransactionHandler();
        try {
            void var11_19;
            if (this.mediaGroup.detector != null) {
                this.mediaGroup.detector.alreadyListening = this.dtmf;
            }
            this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
            ArrayList<Object> eveNames = new ArrayList<Object>();
            ArrayList<EventName> eveNamesDetector = new ArrayList<EventName>();
            EndpointIdentifier endpointID = new EndpointIdentifier(this.mediaGroup.getEndpoint(), this.mgcpWrapper.getPeerIp() + ":" + this.mgcpWrapper.getPeerPort());
            this.mediaGroup.reqId = this.mgcpWrapper.getUniqueRequestIdentifier();
            this.mgcpWrapper.addListener(this.mediaGroup.reqId, (JainMgcpExtendedListener)this);
            NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, this.mediaGroup.reqId);
            ConnectionIdentifier connId = this.mediaGroup.thisConnId;
            RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
            boolean isTTS = false;
            EventName[] signalRequests = null;
            PackageName auPackageName = PackageName.factory((String)"AU");
            if (this.uriList != null) {
                URI uri = this.uriList.poll();
                for (DefaultEventGeneratorFactory genfact : this.mediaGroup.medGrpConfig.getPlayerConfig().getEventGenFctList()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("We are doing media playback " + uri + " for genfact = " + genfact));
                    }
                    if (uri.getScheme().equalsIgnoreCase("data")) {
                        isTTS = true;
                        MgcpEvent e = MgcpEvent.factory((String)"ann");
                        String text = uri.getSchemeSpecificPart().replace('+', ' ');
                        eveNames.add(new EventName(auPackageName, e.withParm(text), connId));
                        continue;
                    }
                    if (genfact.getEventName().compareTo(MgcpEvent.ann.getName()) != 0) continue;
                    String parameter = uri.toString();
                    if (this.startOffset != 0) {
                        parameter = parameter + " SO=" + this.startOffset;
                    }
                    if (this.maxDuration != -1) {
                        parameter = parameter + " MD=" + this.maxDuration;
                    }
                    eveNames.add(genfact.generateMgcpEvent(parameter, connId));
                }
            }
            if (this.dtmf && this.mediaGroup.getSignalDetectorExt() != null) {
                for (SignalDetectorEventDetectorFactory signalDetectorEventDetectorFactory : this.mediaGroup.medGrpConfig.getSigDetConfig().getEventDetFctList()) {
                    eveNamesDetector.add(signalDetectorEventDetectorFactory.generateMgcpEvent(null, connId));
                }
            }
            signalRequests = new EventName[eveNames.size()];
            eveNames.toArray(signalRequests);
            eveNames.clear();
            if (signalRequests.length > 0) {
                notificationRequest.setSignalRequests(signalRequests);
            }
            if (this.uriList != null && !isTTS) {
                for (PlayerEventDetectorFactory playerEventDetectorFactory : this.mediaGroup.medGrpConfig.getPlayerConfig().getEventDetFctList()) {
                    eveNames.add(playerEventDetectorFactory.generateMgcpEvent(null, connId));
                }
            }
            eveNames.addAll(eveNamesDetector);
            if (isTTS) {
                eveNames.add(new EventName(auPackageName, MgcpEvent.oc, connId));
                eveNames.add(new EventName(auPackageName, MgcpEvent.of, connId));
            }
            RequestedEvent[] requestedEvents = new RequestedEvent[eveNames.size()];
            boolean bl = false;
            while (var11_19 < requestedEvents.length) {
                requestedEvents[var11_19] = new RequestedEvent((EventName)eveNames.get((int)var11_19), actions);
                ++var11_19;
            }
            notificationRequest.setRequestedEvents(requestedEvents);
            notificationRequest.setTransactionHandle(this.tx);
            notificationRequest.setNotifiedEntity(this.mgcpWrapper.getDefaultNotifiedEntity());
            this.mediaGroup.getPlayerExt().startTime = System.currentTimeMillis();
            this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
        }
        catch (Exception e) {
            logger.error((Object)"Uncought error", (Throwable)e);
            this.mgcpWrapper.removeListener(this.tx);
            this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
            PlayerEventImpl event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error while sending RQNt " + e.getMessage());
            this.playNextFile(event);
        }
    }

    public void transactionEnded(int arg0) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Successfully completed Tx = " + arg0));
        }
    }

    public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Couldn't send the Tx = " + arg0));
        }
    }

    public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
        try {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
            if (this.dtmf && this.mediaGroup.detector != null) {
                SignalDetectorEventImpl event2 = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEvent.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + cmdEvent.toString());
                this.mediaGroup.detector.update(event2);
            }
            if (this.uriList != null) {
                PlayerEventImpl event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "No response from MGW for RQNT");
                this.playNextFile(event);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Uncought error", (Throwable)e);
        }
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        logger.error((Object)(" The NTFY received " + command.toString()));
        try {
            PlayerEventImpl event = null;
            Notify notify = (Notify)command;
            NotifyResponse response = new NotifyResponse(notify.getSource(), ReturnCode.Transaction_Executed_Normally);
            response.setTransactionHandle(notify.getTransactionHandle());
            this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{response});
            switch (command.getObjectIdentifier()) {
                case 108: {
                    EventName[] observedEvents;
                    for (EventName observedEvent : observedEvents = notify.getObservedEvents()) {
                        if (this.mediaGroup.medGrpConfig.getPlayerConfig() != null) {
                            for (PlayerEventDetectorFactory playerEventDetectorFactory : this.mediaGroup.medGrpConfig.getPlayerConfig().getEventDetFctListALL()) {
                                if (playerEventDetectorFactory.getPkgName().compareTo(observedEvent.getPackageName().toString()) != 0 || playerEventDetectorFactory.getEventName().compareTo(observedEvent.getEventIdentifier().getName()) != 0) continue;
                                logger.info((Object)(" The NTFY is player " + command.toString()));
                                event = (PlayerEventImpl)playerEventDetectorFactory.generateMediaEvent();
                                event.setPlayer(this.mediaGroup.player);
                                event.setSuccessful(true);
                                long playTime = System.currentTimeMillis() - this.mediaGroup.getPlayerExt().startTime;
                                if (this.maxDuration != -1 && (long)this.maxDuration - playTime < 500L) {
                                    this.qualifier = PlayerEvent.DURATION_EXCEEDED;
                                }
                                event.setQualifier(this.qualifier);
                                logger.debug((Object)(" event is successful =  " + event.isSuccessful()));
                                this.playNextFile(event);
                                break;
                            }
                        }
                        if (this.mediaGroup.detector == null) continue;
                        for (SignalDetectorEventDetectorFactory signalDetectorEventDetectorFactory : this.mediaGroup.medGrpConfig.getSigDetConfig().getEventDetFctList()) {
                            if (signalDetectorEventDetectorFactory.getPkgName().compareTo(observedEvent.getPackageName().toString()) != 0 || signalDetectorEventDetectorFactory.getEventName().compareTo(observedEvent.getEventIdentifier().getName()) != 0) continue;
                            logger.info((Object)(" The NTFY is DTMF " + command.toString() + " receiving:" + this.mediaGroup.detector.receiving + " singlasLeft:" + this.mediaGroup.detector.numSignalsLeft));
                            String digitDetected = SignalDetectorImpl.mgcpEventToDTMF(observedEvent.getEventIdentifier());
                            logger.error((Object)("Received " + command));
                            SignalDetectorImpl detector = this.mediaGroup.getSignalDetectorExt();
                            Parameters params = this.mediaGroup.getParameters(null);
                            if (Boolean.TRUE.equals(params.get((Object)SignalDetectorImpl.BUFFERING))) {
                                this.mediaGroup.getSignalDetectorExt().buffer.add(digitDetected);
                            }
                            SignalDetectorEventImpl detectorEvent = null;
                            EventType[] eventTypes = (EventType[])params.get((Object)SignalDetectorImpl.ENABLED_EVENTS);
                            if (eventTypes != null) {
                                for (EventType et : eventTypes) {
                                    if (!et.equals(EventTypeEnum.SIGNAL_DETECTED)) continue;
                                    detectorEvent = (SignalDetectorEventImpl)signalDetectorEventDetectorFactory.generateMediaEvent();
                                    detectorEvent.setDetector(detector);
                                    detectorEvent.setSuccessful(true);
                                    detectorEvent.setSignal(digitDetected);
                                    detectorEvent.setQualifier(SignalDetectorEvent.NO_QUALIFIER);
                                    detector.update(detectorEvent);
                                }
                            }
                            if (!detector.receiving) continue;
                            logger.info((Object)("We are receiving DTMF. We are waiting for numSingals=" + detector.numSignalsLeft + " so far in cache are: " + detector.numSignalsCache));
                            --detector.numSignalsLeft;
                            detector.numSignalsCache = detector.numSignalsCache + digitDetected;
                            int patternIndex = -1;
                            if (detector.patterns != null) {
                                for (int q = 0; q < detector.patterns.length; ++q) {
                                    Parameter p = detector.patterns[q];
                                    String patt = (String)detector.optionlArgs.get((Object)p);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("COMAPRING ----------------------------::::;" + patt + "  " + detector.numSignalsCache + " digit " + digitDetected));
                                    }
                                    if (!detector.numSignalsCache.endsWith(patt)) continue;
                                    patternIndex = SignalDetectorImpl.paramEnumToIndex((ParameterEnum)p);
                                    detector.numSignalsCache = patt;
                                    if (!logger.isDebugEnabled()) break;
                                    logger.debug((Object)("Matched " + p + "  " + patternIndex));
                                    break;
                                }
                            }
                            if (patternIndex == -1 && logger.isDebugEnabled()) {
                                logger.debug((Object)("Not matched" + detector.numSignalsCache));
                            }
                            if (detector.numSignalsLeft == 0 || patternIndex >= 0) {
                                detector.receiving = false;
                                detectorEvent = new SignalDetectorEventImpl(detector, (EventType)EventTypeEnum.RECEIVE_SIGNALS_COMPLETED, true);
                                if (patternIndex < 0) {
                                    detectorEvent.setQualifier(SignalDetectorEvent.NUM_SIGNALS_DETECTED);
                                } else {
                                    detectorEvent.setQualifier(SignalDetectorEvent.PATTERN_MATCHING[patternIndex]);
                                    detectorEvent.setPatterIndex(patternIndex);
                                }
                                detectorEvent.setSuccessful(true);
                                detectorEvent.setSignal(detector.numSignalsCache);
                                logger.info((Object)("delivering eevent" + detectorEvent));
                                detector.update(detectorEvent);
                                detector.numSignalsCache = new String();
                            }
                            if (detector.numSignalsLeft >= 0 || !logger.isInfoEnabled()) continue;
                            logger.info((Object)("NEGATIVE NUMSIGNALS, a skipped digit? cache=" + detector.numSignalsCache));
                        }
                    }
                    break;
                }
                default: {
                    logger.error((Object)("Expected NTFY cmd. Received " + command));
                    event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Player failed on Server");
                    this.playNextFile(event);
                }
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Uncought error", (Throwable)e);
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
        try {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    if (this.dtmf && this.mediaGroup.detector != null) {
                        SignalDetectorEventImpl event2 = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEvent.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                        this.mediaGroup.detector.update(event2);
                    }
                    if (this.uriList != null) {
                        PlayerEventImpl event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                        this.playNextFile(event);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Uncought error", (Throwable)e);
        }
    }

    private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
        PlayerEventImpl event = null;
        ReturnCode returnCode = responseEvent.getReturnCode();
        switch (returnCode.getValue()) {
            case 100: {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                break;
            }
            case 200: {
                this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                break;
            }
            case 502: {
                this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                logger.error((Object)(" ENDPOINT_INSUFFICIENT_RESOURCES for req id = " + this.mediaGroup.reqId));
                if (this.dtmf && this.mediaGroup.detector != null) {
                    SignalDetectorEventImpl event2 = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEvent.SIGNAL_DETECTED, false, MediaErr.RESOURCE_UNAVAILABLE, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    this.mediaGroup.detector.update(event2);
                }
                if (this.uriList == null) break;
                event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.RESOURCE_UNAVAILABLE, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                this.playNextFile(event);
                break;
            }
            default: {
                logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                if (this.dtmf && this.mediaGroup.detector != null) {
                    SignalDetectorEventImpl event2 = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEvent.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    this.mediaGroup.detector.update(event2);
                }
                if (this.uriList == null) break;
                event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                this.playNextFile(event);
            }
        }
    }
}

