/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;

public class MediaGroupStopTx
implements Runnable,
JainMgcpExtendedListener {
    private static final Logger logger = Logger.getLogger(MediaGroupStopTx.class);
    private int tx = -1;
    MgcpWrapper mgcpWrapper;
    MediaGroupImpl mediaGroup;

    MediaGroupStopTx(MgcpWrapper mgcpWrapper, MediaGroupImpl mediaGroup) {
        this.mgcpWrapper = mgcpWrapper;
        this.mediaGroup = mediaGroup;
    }

    public void run() {
        block3: {
            try {
                this.tx = this.mgcpWrapper.getUniqueTransactionHandler();
                this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                this.mgcpWrapper.addListener(this.mediaGroup.reqId, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(this.mediaGroup.getEndpoint(), this.mgcpWrapper.getPeerIp() + ":" + this.mgcpWrapper.getPeerPort());
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, this.mediaGroup.reqId);
                notificationRequest.setTransactionHandle(this.tx);
                notificationRequest.setNotifiedEntity(this.mgcpWrapper.getDefaultNotifiedEntity());
                this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                Object event;
                logger.error((Object)"Error", (Throwable)e);
                this.mgcpWrapper.removeListener(this.tx);
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                if (this.mediaGroup.player != null) {
                    this.mediaGroup.player.updateState();
                    event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error " + e.getMessage());
                    this.mediaGroup.player.update((PlayerEvent)event);
                    this.mediaGroup.player.executeNextTx();
                }
                if (this.mediaGroup.detector == null) break block3;
                event = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEventImpl.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "Error " + e.getMessage());
                this.mediaGroup.detector.update((SignalDetectorEvent)event);
            }
        }
    }

    public void transactionEnded(int arg0) {
    }

    public void transactionRxTimedOut(JainMgcpCommandEvent cmdEvent) {
    }

    public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
        Object event;
        logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
        this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
        this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
        if (this.mediaGroup.player != null) {
            event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error ");
            ((PlayerEventImpl)event).setQualifier(PlayerEvent.STOPPED);
            this.mediaGroup.player.update((PlayerEvent)event);
            this.mediaGroup.player.executeNextTx();
        }
        if (this.mediaGroup.detector != null) {
            event = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEventImpl.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "Error ");
            this.mediaGroup.detector.update((SignalDetectorEvent)event);
        }
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)arg0);
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
        switch (respEvent.getObjectIdentifier()) {
            case 207: {
                this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                break;
            }
            default: {
                Object event;
                this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                if (this.mediaGroup.player != null) {
                    event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error ");
                    ((PlayerEventImpl)event).setQualifier(PlayerEvent.STOPPED);
                    this.mediaGroup.player.update((PlayerEvent)event);
                    this.mediaGroup.player.executeNextTx();
                }
                if (this.mediaGroup.detector == null) break;
                event = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEventImpl.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "Error ");
                this.mediaGroup.detector.update((SignalDetectorEvent)event);
            }
        }
    }

    private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
        ReturnCode returnCode = responseEvent.getReturnCode();
        switch (returnCode.getValue()) {
            case 100: {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                break;
            }
            case 200: {
                Object event;
                this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                if (this.mediaGroup.player != null) {
                    event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, true, PlayerEvent.STOPPED, null);
                    ((PlayerEventImpl)event).setQualifier(PlayerEvent.STOPPED);
                    this.mediaGroup.player.update((PlayerEvent)event);
                    this.mediaGroup.player.executeNextTx();
                }
                if (this.mediaGroup.detector == null) break;
                event = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEvent.SIGNAL_DETECTED, true);
                ((SignalDetectorEventImpl)event).setQualifier(SignalDetectorEvent.STOPPED);
                this.mediaGroup.detector.update((SignalDetectorEvent)event);
                break;
            }
            default: {
                Object event;
                logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                this.mgcpWrapper.removeListener(this.mediaGroup.reqId);
                if (this.mediaGroup.player != null) {
                    event = new PlayerEventImpl((Player)this.mediaGroup.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error ");
                    ((PlayerEventImpl)event).setQualifier(PlayerEvent.STOPPED);
                    this.mediaGroup.player.update((PlayerEvent)event);
                    this.mediaGroup.player.executeNextTx();
                }
                if (this.mediaGroup.detector == null) break;
                event = new SignalDetectorEventImpl(this.mediaGroup.detector, SignalDetectorEventImpl.SIGNAL_DETECTED, false, MediaErr.UNKNOWN_ERROR, "Error ");
                this.mediaGroup.detector.update((SignalDetectorEvent)event);
            }
        }
    }
}

