/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Trigger;
import javax.media.mscontrol.resource.enums.EventTypeEnum;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventDetectorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerConfig {
    private final ParametersImpl parameters;
    private final Set<EventType> eventTypes;
    private final Set<Qualifier> qualifiers;
    private final Set<Trigger> triggers;
    private final Set<Value> values;
    private final Set<Action> actions;
    private final List<PlayerEventDetectorFactory> eventDetFctList;
    private final List<DefaultEventGeneratorFactory> eventGenFctList;
    private final List<PlayerEventDetectorFactory> eventDetFctListTTS;
    private final List<DefaultEventGeneratorFactory> eventGenFctListTTS;
    private final List<PlayerEventDetectorFactory> eventDetFctListALL;

    private PlayerConfig(boolean clone) {
        this.parameters = new ParametersImpl();
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.actions = new HashSet<Action>();
        this.eventDetFctList = new ArrayList<PlayerEventDetectorFactory>();
        this.eventGenFctList = new ArrayList<DefaultEventGeneratorFactory>();
        this.eventDetFctListTTS = new ArrayList<PlayerEventDetectorFactory>();
        this.eventGenFctListTTS = new ArrayList<DefaultEventGeneratorFactory>();
        this.eventDetFctListALL = new ArrayList<PlayerEventDetectorFactory>();
    }

    public PlayerConfig() {
        this.eventDetFctList = this.constructEveDetFctList();
        this.eventGenFctList = this.constructEveGenFctList();
        this.eventDetFctListTTS = this.constructEveDetFctListTTS();
        this.eventGenFctListTTS = this.constructEveGenFctListTTS();
        this.eventDetFctListALL = this.constructEveDetFctListALL();
        this.parameters = new ParametersImpl();
        this.parameters.put(Player.BEHAVIOUR_IF_BUSY, (Object)Player.QUEUE_IF_BUSY);
        this.parameters.put(Player.MAX_DURATION, (Object)-1);
        this.parameters.put(Player.INTERVAL, (Object)new Integer(0));
        this.parameters.put(Player.REPEAT_COUNT, (Object)new Integer(1));
        this.parameters.put(Player.START_OFFSET, (Object)new Integer(0));
        this.eventTypes = new HashSet<EventType>();
        for (PlayerEventDetectorFactory fac : this.eventDetFctList) {
            this.eventTypes.add(fac.getMediaEventType());
        }
        this.qualifiers = new HashSet<Qualifier>();
        this.qualifiers.add(PlayerEvent.DURATION_EXCEEDED);
        this.qualifiers.add(PlayerEvent.END_OF_PLAY_LIST);
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.values.add(Player.FAIL_IF_BUSY);
        this.values.add(Player.QUEUE_IF_BUSY);
        this.values.add(Player.STOP_IF_BUSY);
        this.actions = new HashSet<Action>();
    }

    private List<PlayerEventDetectorFactory> constructEveDetFctList() {
        ArrayList<PlayerEventDetectorFactory> detectorList = new ArrayList<PlayerEventDetectorFactory>();
        PlayerEventDetectorFactory event = new PlayerEventDetectorFactory(PackageName.Announcement.toString(), MgcpEvent.oc.getName(), false, (EventType)EventTypeEnum.PLAY_COMPLETED, true);
        detectorList.add(event);
        event = new PlayerEventDetectorFactory(PackageName.Announcement.toString(), MgcpEvent.of.getName(), false, (EventType)EventTypeEnum.PLAY_COMPLETED, false);
        detectorList.add(event);
        return detectorList;
    }

    private List<PlayerEventDetectorFactory> constructEveDetFctListALL() {
        ArrayList<PlayerEventDetectorFactory> detectorList = new ArrayList<PlayerEventDetectorFactory>();
        detectorList.addAll(this.constructEveDetFctList());
        detectorList.addAll(this.constructEveDetFctListTTS());
        return detectorList;
    }

    private List<PlayerEventDetectorFactory> constructEveDetFctListTTS() {
        PackageName auPackageName = PackageName.factory((String)"AU");
        ArrayList<PlayerEventDetectorFactory> detectorList = new ArrayList<PlayerEventDetectorFactory>();
        PlayerEventDetectorFactory event = new PlayerEventDetectorFactory(auPackageName.toString(), MgcpEvent.oc.getName(), false, (EventType)EventTypeEnum.PLAY_COMPLETED, true);
        detectorList.add(event);
        event = new PlayerEventDetectorFactory(auPackageName.toString(), MgcpEvent.of.getName(), false, (EventType)EventTypeEnum.PLAY_COMPLETED, false);
        detectorList.add(event);
        return detectorList;
    }

    private List<DefaultEventGeneratorFactory> constructEveGenFctList() {
        ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
        DefaultEventGeneratorFactory ann = new DefaultEventGeneratorFactory(PackageName.Announcement.toString(), MgcpEvent.ann.getName(), false);
        generatorList.add(ann);
        return generatorList;
    }

    private List<DefaultEventGeneratorFactory> constructEveGenFctListTTS() {
        ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
        PackageName auPackageName = PackageName.factory((String)"AU");
        DefaultEventGeneratorFactory ann = new DefaultEventGeneratorFactory(auPackageName.toString(), MgcpEvent.ann.getName(), false);
        generatorList.add(ann);
        return generatorList;
    }

    public ParametersImpl getParametersImpl() {
        return this.parameters;
    }

    public void setParametersImpl(Parameters params) {
        for (Parameter p : params.keySet()) {
            for (Parameter actual : this.parameters.keySet()) {
                if (p != actual) continue;
                this.parameters.put(actual, params.get((Object)actual));
            }
        }
    }

    public Set<Parameter> getParameters() {
        return this.parameters.keySet();
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Set<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public Set<Value> getValues() {
        return this.values;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    protected List<PlayerEventDetectorFactory> getEventDetFctList() {
        return this.eventDetFctList;
    }

    protected List<DefaultEventGeneratorFactory> getEventGenFctList() {
        return this.eventGenFctList;
    }

    protected List<PlayerEventDetectorFactory> getEventDetFctListTTS() {
        return this.eventDetFctListTTS;
    }

    protected List<DefaultEventGeneratorFactory> getEventGenFctListTTS() {
        return this.eventGenFctListTTS;
    }

    protected List<PlayerEventDetectorFactory> getEventDetFctListALL() {
        return this.eventDetFctListALL;
    }

    public PlayerConfig createCustomizedClone(Parameters params) {
        PlayerConfig clone = new PlayerConfig(true);
        clone.parameters.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parameters));
        clone.eventTypes.addAll(this.eventTypes);
        clone.qualifiers.addAll(this.qualifiers);
        clone.triggers.addAll(this.triggers);
        clone.values.addAll(this.values);
        clone.actions.addAll(this.actions);
        clone.eventDetFctList.addAll(this.eventDetFctList);
        clone.eventGenFctList.addAll(this.eventGenFctList);
        if (params != null && params != Parameters.NO_PARAMETER) {
            for (Parameter p : clone.parameters.keySet()) {
                for (Parameter pArg : params.keySet()) {
                    if (!p.equals(pArg)) continue;
                    clone.parameters.put(pArg, params.get((Object)pArg));
                }
            }
        }
        return clone;
    }
}

