/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.message.parms.EventName;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.RTC;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.EventExecutor;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupRequestTx;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupStopTx;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerState;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerImpl
implements Player {
    private static final String ZERO = "zero";
    private static final String ONE = "one";
    private static final String TWO = "two";
    private static final String THREE = "three";
    private static final String FOUR = "four";
    private static final String FIVE = "five";
    private static final String SIX = "six";
    private static final String SEVEN = "seven";
    private static final String EIGHT = "eight";
    private static final String NINE = "nine";
    static final int PLAY_TOLERANCE = 500;
    private static Logger logger = Logger.getLogger(PlayerImpl.class);
    protected MediaGroupImpl mediaGroup = null;
    protected CopyOnWriteArrayList<MediaEventListener<PlayerEvent>> mediaEventListenerList = new CopyOnWriteArrayList();
    protected final MediaSessionImpl mediaSession;
    protected final MgcpWrapper mgcpWrapper;
    private final MediaGroupConfig medGrpConfig;
    protected volatile PlayerState state = PlayerState.IDLE;
    volatile long startTime = 0L;
    private volatile LinkedList<Runnable> txList = new LinkedList();
    private List<EventName> eveNames = new ArrayList<EventName>();

    protected PlayerImpl(MediaGroupImpl mediaGroup, MgcpWrapper mgcpWrapper, MediaGroupConfig medGrpConfig) throws MsControlException {
        this.mediaGroup = mediaGroup;
        this.mediaSession = (MediaSessionImpl)mediaGroup.getMediaSession();
        this.mgcpWrapper = mgcpWrapper;
        this.medGrpConfig = medGrpConfig;
    }

    void updateState() {
        this.state = this.txList.size() == 0 ? PlayerState.IDLE : PlayerState.ACTIVE;
    }

    void executeNextTx() {
        Runnable nextTx = this.txList.poll();
        if (nextTx != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Executing next Tx in TxList");
            }
            this.state = PlayerState.ACTIVE;
            Provider.submit(nextTx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkURI(URI[] uris) throws MsControlException {
        if (uris == null) {
            throw new MsControlException("URI[] cannot be null");
        }
        for (URI uri : uris) {
            if (uri == null) {
                throw new MsControlException("URI cannot be null");
            }
            if (uri.getScheme().equalsIgnoreCase("data")) continue;
            InputStream is = null;
            try {
                is = uri.toURL().openStream();
            }
            catch (MalformedURLException e) {
                logger.error((Object)"Cannot play the file", (Throwable)e);
                PlayerEventImpl event = new PlayerEventImpl((Player)this, PlayerEvent.PLAY_COMPLETED, false, MediaErr.BAD_ARG, "Error " + e.getMessage());
                this.update(event);
                break;
            }
            catch (IOException e) {
                logger.error((Object)"Cannot play the file", (Throwable)e);
                PlayerEventImpl event = new PlayerEventImpl((Player)this, PlayerEvent.PLAY_COMPLETED, false, MediaErr.NOT_FOUND, "Error " + e.getMessage());
                this.update(event);
                break;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)"Closing of Stream failed", (Throwable)e);
                    }
                }
            }
        }
    }

    public void play(URI[] uris, RTC[] arg1, Parameters params) throws MsControlException {
        Parameters p;
        this.checkURI(uris);
        if (MediaObjectState.JOINED.equals((Object)this.mediaGroup.getState())) {
            p = null;
            if (params != Parameters.NO_PARAMETER) {
                p = this.mediaGroup.createParameters();
                p.putAll((Map)((Object)this.medGrpConfig.getParametersImpl()));
                p.putAll((Map)params);
            } else {
                p = this.medGrpConfig.getParametersImpl();
            }
        } else {
            throw new MsControlException(this.mediaGroup.getURI() + " Container is not joined to any other container");
        }
        this.mediaGroup.detector.alreadyListening = true;
        this.executeTx(uris, arg1, p);
    }

    public void play(URI uri, RTC[] arg1, Parameters params) throws MsControlException {
        Parameters p;
        URI[] uris = new URI[]{uri};
        this.checkURI(uris);
        if (MediaObjectState.JOINED.equals((Object)this.mediaGroup.getState())) {
            p = null;
            if (params != Parameters.NO_PARAMETER) {
                p = this.mediaGroup.createParameters();
                p.putAll((Map)((Object)this.medGrpConfig.getParametersImpl()));
                p.putAll((Map)params);
            } else {
                p = this.medGrpConfig.getParametersImpl();
            }
            if (this.mediaGroup.detector != null) {
                this.mediaGroup.detector.alreadyListening = true;
            }
        } else {
            throw new MsControlException(this.mediaGroup.getURI() + " Container is not joined to any other container");
        }
        this.executeTx(uris, arg1, p);
    }

    private int getRepeatCount(String repeatCount) {
        if (ZERO.equalsIgnoreCase(repeatCount)) {
            return 0;
        }
        if (ONE.equalsIgnoreCase(repeatCount)) {
            return 1;
        }
        if (TWO.equalsIgnoreCase(repeatCount)) {
            return 2;
        }
        if (THREE.equalsIgnoreCase(repeatCount)) {
            return 3;
        }
        if (FOUR.equalsIgnoreCase(repeatCount)) {
            return 4;
        }
        if (FIVE.equalsIgnoreCase(repeatCount)) {
            return 5;
        }
        if (SIX.equalsIgnoreCase(repeatCount)) {
            return 6;
        }
        if (SEVEN.equalsIgnoreCase(repeatCount)) {
            return 7;
        }
        if (EIGHT.equalsIgnoreCase(repeatCount)) {
            return 8;
        }
        if (NINE.equalsIgnoreCase(repeatCount)) {
            return 9;
        }
        return 0;
    }

    private void executeTx(URI[] uris, RTC[] arg1, Parameters params) throws MsControlException {
        Value action_if_busy = QUEUE_IF_BUSY;
        int repeatCount = 0;
        int interval = 0;
        int startOffset = 0;
        int maxDuration = -1;
        boolean update = true;
        LinkedList<URI> uriList = new LinkedList<URI>();
        for (URI uri : uris) {
            uriList.add(uri);
        }
        action_if_busy = (Value)params.get((Object)BEHAVIOUR_IF_BUSY);
        Object obj = params.get((Object)REPEAT_COUNT);
        repeatCount = obj instanceof String ? this.getRepeatCount((String)obj) : ((Integer)obj).intValue();
        if (repeatCount < 1) {
            repeatCount = 1;
        }
        if ((interval = ((Integer)params.get((Object)INTERVAL)).intValue()) < 0) {
            interval = 0;
        }
        if ((maxDuration = ((Integer)params.get((Object)MAX_DURATION)).intValue()) < 1) {
            maxDuration = -1;
        }
        startOffset = (Integer)params.get((Object)START_OFFSET);
        if (repeatCount > 1) {
            update = false;
        }
        if (this.state == PlayerState.ACTIVE) {
            if (action_if_busy == Player.QUEUE_IF_BUSY) {
                MediaGroupRequestTx tx = new MediaGroupRequestTx(this.mgcpWrapper, this.mediaGroup, uriList, startOffset, maxDuration, update, this.mediaGroup.detector != null);
                this.txList.add(tx);
                logger.info((Object)"Queuing new player transaction");
            } else if (action_if_busy == Player.STOP_IF_BUSY) {
                logger.info((Object)"Stopping current player transaction and starting new one");
                this.txList.clear();
                MediaGroupRequestTx tx = new MediaGroupRequestTx(this.mgcpWrapper, this.mediaGroup, uriList, startOffset, maxDuration, update, this.mediaGroup.detector != null);
                this.txList.add(tx);
                this.executeNextTx();
            } else {
                if (action_if_busy == Player.FAIL_IF_BUSY) {
                    throw new MsControlException("Player is busy");
                }
                logger.error((Object)("The Value " + action_if_busy + " is not recognized for Parameter p_IfBusy. It has to be one of Player.v_Queue, Player.v_Stop or Player.v_Fail"));
            }
        } else {
            MediaGroupRequestTx tx = new MediaGroupRequestTx(this.mgcpWrapper, this.mediaGroup, uriList, startOffset, maxDuration, update, this.mediaGroup.detector != null);
            Provider.submit(tx);
        }
        this.state = PlayerState.ACTIVE;
        for (int i = 1; i < repeatCount; ++i) {
            if (interval != 0) {
                IntervalTx tx = new IntervalTx(interval);
                this.txList.add(tx);
            }
            if (i == repeatCount - 1) {
                update = true;
            }
            LinkedList<URI> uriListTemp = new LinkedList<URI>();
            for (URI uri : uris) {
                uriListTemp.add(uri);
            }
            MediaGroupRequestTx tx = new MediaGroupRequestTx(this.mgcpWrapper, this.mediaGroup, uriListTemp, startOffset, maxDuration, update, this.mediaGroup.detector != null);
            this.txList.add(tx);
        }
    }

    public MediaGroup getContainer() {
        return this.mediaGroup;
    }

    public void stop(boolean stopAll) {
        this.txList.clear();
        if (this.state == PlayerState.ACTIVE) {
            MediaGroupStopTx tx = new MediaGroupStopTx(this.mgcpWrapper, this.mediaGroup);
            Provider.submit(tx);
        }
    }

    public void addListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public void removeListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaGroup.getMediaSession();
    }

    protected void update(PlayerEvent anEvent) {
        int offset = (int)(System.currentTimeMillis() - this.startTime);
        ((PlayerEventImpl)anEvent).setOffset(offset);
        for (MediaEventListener<PlayerEvent> m : this.mediaEventListenerList) {
            EventExecutor exe = new EventExecutor(m, (MediaEvent)anEvent);
            Provider.submit(exe);
        }
    }

    private class IntervalTx
    implements Runnable {
        int interval = 0;

        IntervalTx(int interval) {
            this.interval = interval;
        }

        public void run() {
            try {
                logger.info((Object)("The Interval for " + this.interval));
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Huh", (Throwable)e);
            }
            PlayerImpl.this.executeNextTx();
        }
    }
}

