/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Resource;
import javax.media.mscontrol.resource.Trigger;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderEventDetectorFactory;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.mobicents.protocols.mgcp.jain.pkg.AUPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderConfig {
    private final List<DefaultEventGeneratorFactory> eventGenFctList;
    private final List<RecorderEventDetectorFactory> eventDetFctList;
    private final ParametersImpl parametersImpl = new ParametersImpl();
    private final Set<EventType> eventTypes;
    private final Set<Qualifier> qualifiers;
    private final Set<Trigger> triggers;
    private final Set<Value> values;
    private final Set<Action> actions;

    private RecorderConfig(boolean clone) {
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.actions = new HashSet<Action>();
        this.eventDetFctList = new ArrayList<RecorderEventDetectorFactory>();
        this.eventGenFctList = new ArrayList<DefaultEventGeneratorFactory>();
    }

    public RecorderConfig() {
        this.parametersImpl.put(Recorder.MAX_DURATION, (Object)Resource.FOR_EVER);
        this.parametersImpl.put(Recorder.START_BEEP, (Object)false);
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.actions = new HashSet<Action>();
        this.eventGenFctList = this.constructEveGenFctList();
        this.eventDetFctList = new ArrayList<RecorderEventDetectorFactory>();
    }

    private List<DefaultEventGeneratorFactory> constructEveGenFctList() {
        ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
        DefaultEventGeneratorFactory ann = new DefaultEventGeneratorFactory(AUPackage.AU.toString(), AUMgcpEvent.aupr.getName(), false);
        generatorList.add(ann);
        return generatorList;
    }

    protected List<DefaultEventGeneratorFactory> getEventGenFctList() {
        return this.eventGenFctList;
    }

    protected List<RecorderEventDetectorFactory> getEventDetFctList() {
        return this.eventDetFctList;
    }

    public ParametersImpl getParametersImpl() {
        return this.parametersImpl;
    }

    public void setParametersImpl(Parameters params) {
        for (Parameter p : params.keySet()) {
            for (Parameter actual : this.parametersImpl.keySet()) {
                if (p != actual) continue;
                this.parametersImpl.put(actual, params.get((Object)actual));
            }
        }
    }

    public Set<Parameter> getParameters() {
        return this.parametersImpl.keySet();
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Set<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public Set<Value> getValues() {
        return this.values;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public RecorderConfig createCustomizedClone(Parameters params) {
        RecorderConfig clone = new RecorderConfig(true);
        clone.parametersImpl.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parametersImpl));
        clone.eventTypes.addAll(this.eventTypes);
        clone.qualifiers.addAll(this.qualifiers);
        clone.triggers.addAll(this.triggers);
        clone.values.addAll(this.values);
        clone.actions.addAll(this.actions);
        clone.eventDetFctList.addAll(this.eventDetFctList);
        clone.eventGenFctList.addAll(this.eventGenFctList);
        if (params != null && params != Parameters.NO_PARAMETER) {
            for (Parameter p : clone.parametersImpl.keySet()) {
                for (Parameter pArg : params.keySet()) {
                    if (p != pArg) continue;
                    clone.parametersImpl.put(pArg, params.get((Object)pArg));
                }
            }
        }
        return clone;
    }
}

