/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Recorder;
import javax.media.mscontrol.mediagroup.RecorderEvent;
import javax.media.mscontrol.resource.RTC;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupConfig;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderState;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderImpl
implements Recorder {
    private static Logger logger = Logger.getLogger(RecorderImpl.class);
    protected MediaGroupImpl mediaGroup = null;
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> mediaEventListenerList = new CopyOnWriteArrayList();
    protected final MediaSessionImpl mediaSession;
    protected final MgcpWrapper mgcpWrapper;
    protected RequestIdentifier reqId = null;
    protected RecorderState state = RecorderState.IDLE;
    private final MediaGroupConfig medGrpConfig;
    private List<EventName> eveNames = new ArrayList<EventName>();

    public RecorderImpl(MediaGroupImpl mediaGroup, MgcpWrapper mgcpWrapper, MediaGroupConfig medGrpConfig) {
        this.mediaGroup = mediaGroup;
        this.mediaSession = (MediaSessionImpl)mediaGroup.getMediaSession();
        this.mgcpWrapper = mgcpWrapper;
        this.medGrpConfig = medGrpConfig;
    }

    public void record(URI streamID, RTC[] rtc, Parameters optargs) throws MsControlException {
        if (MediaObjectState.JOINED.equals((Object)this.mediaGroup.getState())) {
            if (this.state == RecorderState.ACTIVE) {
                throw new MsControlException(this.mediaGroup.getURI() + " Recorder already ACTIVE");
            }
        } else {
            throw new MsControlException(this.mediaGroup.getURI() + " Container is not joined to any other container");
        }
        StartTx tx = new StartTx(this, streamID);
        Provider.submit(tx);
        this.state = RecorderState.ACTIVE;
    }

    public MediaGroup getContainer() {
        return this.mediaGroup;
    }

    public void stop() {
        if (this.state == RecorderState.ACTIVE) {
            StopTx tx = new StopTx(this);
            Provider.submit(tx);
        }
    }

    public void addListener(MediaEventListener<RecorderEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public void removeListener(MediaEventListener<RecorderEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    protected void update(RecorderEvent anEvent) {
        for (MediaEventListener<? extends MediaEvent<?>> mediaEventListener : this.mediaEventListenerList) {
            mediaEventListener.onEvent((MediaEvent)anEvent);
        }
    }

    private class StartTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private Recorder recorder = null;
        private String file = null;

        StartTx(Recorder recorder, URI uri) {
            this.recorder = recorder;
            this.file = uri.toString();
        }

        public void run() {
            this.tx = RecorderImpl.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                RecorderImpl.this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(RecorderImpl.this.mediaGroup.getEndpoint(), RecorderImpl.this.mgcpWrapper.getPeerIp() + ":" + RecorderImpl.this.mgcpWrapper.getPeerPort());
                RecorderImpl.this.reqId = RecorderImpl.this.mgcpWrapper.getUniqueRequestIdentifier();
                RecorderImpl.this.mgcpWrapper.addListener(RecorderImpl.this.reqId, (JainMgcpExtendedListener)this);
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, RecorderImpl.this.reqId);
                notificationRequest.setNotifiedEntity(RecorderImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                ConnectionIdentifier connId = RecorderImpl.this.mediaGroup.thisConnId;
                EventName[] signalRequests = null;
                for (DefaultEventGeneratorFactory genfact : RecorderImpl.this.medGrpConfig.getRecorderConfig().getEventGenFctList()) {
                    if (genfact.getEventName().compareTo(AUMgcpEvent.aupr.getName()) == 0) {
                        RecorderImpl.this.eveNames.add(genfact.generateMgcpEvent(this.file, connId));
                        continue;
                    }
                    RecorderImpl.this.eveNames.add(genfact.generateMgcpEvent(null, connId));
                }
                signalRequests = new EventName[RecorderImpl.this.eveNames.size()];
                RecorderImpl.this.eveNames.toArray(signalRequests);
                RecorderImpl.this.eveNames.clear();
                notificationRequest.setSignalRequests(signalRequests);
                notificationRequest.setTransactionHandle(this.tx);
                RecorderImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                RecorderImpl.this.mgcpWrapper.removeListener(this.tx);
                RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.STARTED, false, MediaErr.UNKNOWN_ERROR, "Error while sending RQNt " + e.getMessage());
                RecorderImpl.this.update(event);
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't send the Tx = " + arg0));
            }
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            RecorderImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
            RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.STARTED, false, MediaErr.UNKNOWN_ERROR, "No response from MGW for RQNT");
            RecorderImpl.this.update(event);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
            logger.debug((Object)(" The NTFY received " + command.toString()));
            Notify notify = (Notify)command;
            EventName[] observedEvents = notify.getObservedEvents();
            RecorderEventImpl event = null;
            block4: for (EventName observedEvent : observedEvents) {
                switch (observedEvent.getEventIdentifier().intValue()) {
                    case 204: {
                        RecorderImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
                        RecorderImpl.this.state = RecorderState.IDLE;
                        MgcpEvent mgcpEvent = observedEvent.getEventIdentifier();
                        String params = mgcpEvent.getParms();
                        event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, true, RecorderEvent.DURATION_EXCEEDED, null, this.getInterval(params));
                        RecorderImpl.this.update(event);
                        continue block4;
                    }
                    case 205: {
                        RecorderImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
                        event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Recorder failed on server ");
                        RecorderImpl.this.update(event);
                    }
                }
            }
            NotifyResponse response = new NotifyResponse(notify.getSource(), ReturnCode.Transaction_Executed_Normally);
            response.setTransactionHandle(notify.getTransactionHandle());
            RecorderImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{response});
        }

        private int getInterval(String params) {
            int inter = -1;
            if (params != null) {
                char[] cArr = params.toCharArray();
                int start = 0;
                boolean end = false;
                for (int i = 0; i < cArr.length - 1; ++i) {
                    if (cArr[i] != 'i' || cArr[i + 1] != 'v') continue;
                    start = i;
                    break;
                }
                boolean decoded = true;
                int count = start + 3;
                String interval = "";
                while (decoded && count < cArr.length) {
                    char ch = cArr[count];
                    if (ch >= '0' && ch <= '9') {
                        ++count;
                        interval = interval + ch;
                        continue;
                    }
                    decoded = false;
                }
                try {
                    inter = Integer.parseInt(interval);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)"Parsing of interval failed ", (Throwable)e);
                }
            }
            return inter;
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    RecorderImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.STARTED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    RecorderImpl.this.update(event);
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            RecorderEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    RecorderImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    break;
                }
                case 502: {
                    RecorderImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    event = new RecorderEventImpl(this.recorder, RecorderEvent.STARTED, false, MediaErr.RESOURCE_UNAVAILABLE, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    RecorderImpl.this.update(event);
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    RecorderImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    event = new RecorderEventImpl(this.recorder, RecorderEvent.STARTED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    RecorderImpl.this.update(event);
                }
            }
        }
    }

    private class StopTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private RecorderImpl recorder = null;

        StopTx(RecorderImpl recorder) {
            this.recorder = recorder;
        }

        public void run() {
            try {
                this.tx = RecorderImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                RecorderImpl.this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                RecorderImpl.this.mgcpWrapper.addListener(RecorderImpl.this.reqId, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(RecorderImpl.this.mediaGroup.getEndpoint(), RecorderImpl.this.mgcpWrapper.getPeerIp() + ":" + RecorderImpl.this.mgcpWrapper.getPeerPort());
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, RecorderImpl.this.reqId);
                notificationRequest.setNotifiedEntity(RecorderImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                notificationRequest.setTransactionHandle(this.tx);
                RecorderImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error while sending RQNt " + e.getMessage());
                RecorderImpl.this.update(event);
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            RecorderImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
            RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "No response from MGW for RQNT");
            RecorderImpl.this.update(event);
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    RecorderImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    RecorderEventImpl event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    RecorderImpl.this.update(event);
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            RecorderEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    RecorderImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    RecorderImpl.this.state = RecorderState.IDLE;
                    event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, true);
                    RecorderImpl.this.update(event);
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    RecorderImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    RecorderImpl.this.mgcpWrapper.removeListener(RecorderImpl.this.reqId);
                    event = new RecorderEventImpl(this.recorder, RecorderEvent.RECORD_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    RecorderImpl.this.update(event);
                }
            }
        }
    }
}

