/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Qualifier;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Trigger;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.resource.ExtendedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkConnectionConfig {
    private final ParametersImpl parametersImpl = new ParametersImpl();
    private final Set<EventType> eventTypes;
    private final Set<Qualifier> qualifiers;
    private final Set<Trigger> triggers;
    private final Set<Value> values;
    private final Set<Action> actions;

    private NetworkConnectionConfig(boolean clone) {
        this.eventTypes = new HashSet<EventType>();
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
        this.actions = new HashSet<Action>();
    }

    public NetworkConnectionConfig() {
        this.parametersImpl.put(ExtendedParameter.ENDPOINT_LOCAL_NAME, (Object)"/mobicents/media/packetrelay/$");
        this.parametersImpl.put(MediaObject.MEDIAOBJECT_ID, (Object)Parameters.NO_PARAMETER);
        this.parametersImpl.put(MediaSession.TIMEOUT, (Object)30000);
        this.actions = new HashSet<Action>();
        this.eventTypes = new HashSet<EventType>();
        this.eventTypes.add(SdpPortManagerEvent.OFFER_GENERATED);
        this.eventTypes.add(SdpPortManagerEvent.ANSWER_GENERATED);
        this.eventTypes.add(SdpPortManagerEvent.ANSWER_PROCESSED);
        this.eventTypes.add(SdpPortManagerEvent.NETWORK_STREAM_FAILURE);
        this.qualifiers = new HashSet<Qualifier>();
        this.triggers = new HashSet<Trigger>();
        this.values = new HashSet<Value>();
    }

    protected ParametersImpl getParametersImpl() {
        ParametersImpl newparams = new ParametersImpl();
        newparams.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parametersImpl));
        return newparams;
    }

    protected void setParametersImpl(Parameters params) {
        for (Parameter p : params.keySet()) {
            for (Parameter actual : this.parametersImpl.keySet()) {
                if (p != actual) continue;
                this.parametersImpl.put(actual, params.get((Object)actual));
            }
        }
    }

    public Set<Parameter> getParameters() {
        return this.parametersImpl.keySet();
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public Set<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Trigger> getTriggers() {
        return this.triggers;
    }

    public Set<Value> getValues() {
        return this.values;
    }

    public Set<Action> getActions() {
        return this.actions;
    }

    public NetworkConnectionConfig createCustomizedClone(Parameters params) {
        NetworkConnectionConfig clone = new NetworkConnectionConfig(true);
        clone.parametersImpl.putAll((Map<? extends Parameter, ? extends Object>)((Object)this.parametersImpl));
        clone.eventTypes.addAll(this.eventTypes);
        clone.qualifiers.addAll(this.qualifiers);
        clone.triggers.addAll(this.triggers);
        clone.values.addAll(this.values);
        clone.actions.addAll(this.actions);
        if (params != null && params != Parameters.NO_PARAMETER) {
            for (Parameter p : clone.parametersImpl.keySet()) {
                for (Parameter pArg : params.keySet()) {
                    if (p != pArg) continue;
                    clone.parametersImpl.put(pArg, params.get((Object)pArg));
                }
            }
        }
        return clone;
    }
}

