/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.networkconnection.CodecPolicy;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.AbstractJoinableContainer;
import org.mobicents.javax.media.mscontrol.AudioJoinableStream;
import org.mobicents.javax.media.mscontrol.EventExecutor;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.SupportedFeaturesImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.MediaParser;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionConfig;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpPortManagerEventImpl;
import org.mobicents.javax.media.mscontrol.resource.ExtendedParameter;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.protocols.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkConnectionImpl
extends AbstractJoinableContainer
implements NetworkConnection {
    public static Logger logger = Logger.getLogger(NetworkConnectionImpl.class);
    private static final SdpFactory sdpFactory = SdpFactory.getInstance();
    private String PR_ENDPOINT_NAME = null;
    private URI uri = null;
    private final SupportedFeaturesImpl suppFeatures;
    private final NetworkConnectionConfig ncConfig;
    private volatile ConnectionIdentifier connectionIdentifier = null;
    private byte[] remoteSessionDescription = null;
    private byte[] localSessionDescription = null;
    private SdpPortManager sdpPortManager = null;
    private Parameters parameters = null;
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> eventListenerList = new CopyOnWriteArrayList();

    public NetworkConnectionImpl(MediaSessionImpl mediaSession, MgcpWrapper mgcpWrapper, MediaConfigImpl config) throws MsControlException {
        this.config = config;
        this.suppFeatures = (SupportedFeaturesImpl)this.config.getSupportedFeatures();
        this.ncConfig = this.suppFeatures.getNetConConfig();
        this.parameters = this.ncConfig.getParametersImpl();
        this.mediaSession = mediaSession;
        String passedId = (String)this.parameters.get((Object)MEDIAOBJECT_ID);
        if (passedId != null) {
            if (!Character.isLetterOrDigit(passedId.charAt(0))) {
                throw new MsControlException("MEDIAOBJECT_ID should start with letter or digit. Invalid first character for passed MEDIAOBJECT_ID = " + passedId);
            }
            for (NetworkConnection nc : this.mediaSession.getNetConnList()) {
                if (((AbstractJoinableContainer)nc).getId().compareTo(passedId) != 0) continue;
                throw new MsControlException("Duplicate MEDIAOBJECT_ID = " + passedId);
            }
            this.id = passedId;
        }
        try {
            this.uri = new URI(mediaSession.getURI().toString() + "/NetworkConnection." + this.id);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.mgcpWrapper = mgcpWrapper;
        this.maxJoinees = 1;
        this.PR_ENDPOINT_NAME = this.endpoint = (String)this.ncConfig.getParametersImpl().get((Object)ExtendedParameter.ENDPOINT_LOCAL_NAME);
        this.sdpPortManager = new SdpPortManagerImpl(this);
    }

    @Override
    protected void checkState() {
        if (this.state.equals((Object)MediaObjectState.RELEASED)) {
            throw new IllegalStateException("State of container " + this.getURI() + " is released");
        }
    }

    @Override
    protected MediaObjectState getState() {
        return this.state;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    protected void joined(ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId) {
    }

    @Override
    protected void resetContainer() {
        if (this.endpoint == null) {
            this.audioJoinableStream = null;
            this.endpoint = this.PR_ENDPOINT_NAME;
        }
    }

    @Override
    protected void unjoined(ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId) {
    }

    public SdpPortManager getSdpPortManager() throws MsControlException {
        return this.sdpPortManager;
    }

    public void confirm() throws MsControlException {
        throw new MsControlException("Operation not yet supported");
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> paramClass) throws MsControlException {
        return null;
    }

    public void triggerRTC(Action paramAction) {
    }

    public Parameters createParameters() {
        return new ParametersImpl();
    }

    public Iterator<MediaObject> getMediaObjects() {
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        return null;
    }

    public Parameters getParameters(Parameter[] paramArrayOfParameter) {
        return null;
    }

    public void release() {
        this.checkState();
        if (this.connectionIdentifier != null) {
            DeleteTx tx = new DeleteTx(this);
            Provider.submit(tx);
        }
        try {
            Joinable[] joinableArray;
            for (Joinable joinable : joinableArray = this.getJoinees()) {
                this.unjoinInitiate(joinable, (Serializable)((Object)this));
            }
        }
        catch (MsControlException e) {
            logger.error((Object)"release of NetworkConnection failed ", (Throwable)e);
        }
        this.state = MediaObjectState.RELEASED;
        this.mediaSession.getNetConnList().remove(this);
    }

    public void setParameters(Parameters paramParameters) {
        this.ncConfig.setParametersImpl(paramParameters);
    }

    public void addListener(AllocationEventListener paramAllocationEventListener) {
    }

    public void removeListener(AllocationEventListener paramAllocationEventListener) {
    }

    public void triggerAction(Action arg0) {
    }

    static /* synthetic */ byte[] access$202(NetworkConnectionImpl x0, byte[] x1) {
        x0.remoteSessionDescription = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$102(NetworkConnectionImpl x0, byte[] x1) {
        x0.localSessionDescription = x1;
        return x1;
    }

    protected class DeleteTx
    implements Runnable,
    JainMgcpExtendedListener {
        private NetworkConnectionImpl networkConnectionImpl;
        private int tx = -1;

        public DeleteTx(NetworkConnectionImpl networkConnectionImpl2) {
            this.networkConnectionImpl = networkConnectionImpl2;
        }

        public void run() {
            try {
                this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                NetworkConnectionImpl.this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                EndpointIdentifier endpointID = new EndpointIdentifier(NetworkConnectionImpl.this.endpoint, NetworkConnectionImpl.this.mgcpWrapper.getPeerIp() + ":" + NetworkConnectionImpl.this.mgcpWrapper.getPeerPort());
                DeleteConnection deleteConnection = new DeleteConnection((Object)this, callId, endpointID, NetworkConnectionImpl.this.connectionIdentifier);
                deleteConnection.setTransactionHandle(this.tx);
                NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
            NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
            if (response.getTransactionHandle() != this.tx) {
                return;
            }
            switch (response.getObjectIdentifier()) {
                case 204: {
                    this.processDeleteConnectionResponse((DeleteConnectionResponse)response);
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(response.getTransactionHandle());
                    logger.warn((Object)(" DLCX of Netwrok connction failed RESPONSE is unexpected " + response));
                }
            }
        }

        private void processDeleteConnectionResponse(DeleteConnectionResponse responseEvent) {
            ReturnCode returnCode = responseEvent.getReturnCode();
            Object joinEvent = null;
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + responseEvent.getTransactionHandle() + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("DLCX executed successfully for Tx = " + responseEvent.getTransactionHandle()));
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SdpPortManagerImpl
    implements SdpPortManager {
        private NetworkConnectionImpl networkConn = null;
        private CodecPolicy codecPolicy = null;

        public SdpPortManagerImpl(NetworkConnectionImpl networkConn) {
            this.networkConn = networkConn;
        }

        public void generateSdpOffer() throws SdpPortManagerException {
            NetworkConnectionImpl.this.checkState();
            if (NetworkConnectionImpl.this.connectionIdentifier != null) {
                throw new SdpPortManagerException("Sdp Offer already generated once");
            }
            CreateTx tx = new CreateTx(this.networkConn, this, false, true, false);
            Provider.submit(tx);
        }

        public CodecPolicy getCodecPolicy() {
            return this.codecPolicy;
        }

        public byte[] getMediaServerSessionDescription() throws SdpPortManagerException {
            return NetworkConnectionImpl.this.localSessionDescription;
        }

        public byte[] getUserAgentSessionDescription() throws SdpPortManagerException {
            return NetworkConnectionImpl.this.remoteSessionDescription;
        }

        private String processCodecPolicy(String rawSdp) throws SdpPortManagerException {
            if (this.codecPolicy != null) {
                if (this.codecPolicy.getCodecCapabilities().length != 0 || this.codecPolicy.getCodecPreferences().length != 0 || this.codecPolicy.getExcludedCodecs().length != 0 || this.codecPolicy.getMediaTypeCapabilities().length != 0 || this.codecPolicy.getRequiredCodecs().length != 0) {
                    try {
                        SessionDescription sessiondescription = sdpFactory.createSessionDescription(rawSdp);
                        Vector v = sessiondescription.getMediaDescriptions(false);
                        for (MediaDescription m : v) {
                            if (this.codecPolicy.getExcludedCodecs().length == 0) continue;
                            MediaParser.excludeCodec(m, this.codecPolicy.getExcludedCodecs());
                        }
                        return sessiondescription.toString();
                    }
                    catch (SdpParseException e) {
                        throw new SdpPortManagerException("Exception while processing the CodecPolicy", (Throwable)e);
                    }
                    catch (SdpException e) {
                        throw new SdpPortManagerException("Exception while processing the CodecPolicy", (Throwable)e);
                    }
                }
                return rawSdp;
            }
            return rawSdp;
        }

        public void processSdpAnswer(byte[] paramArrayOfByte) throws SdpPortManagerException {
            NetworkConnectionImpl.this.checkState();
            if (paramArrayOfByte == null) {
                throw new SdpPortManagerException("The sdp argument passed cannot be null");
            }
            NetworkConnectionImpl.access$202(NetworkConnectionImpl.this, paramArrayOfByte);
            Runnable tx = NetworkConnectionImpl.this.connectionIdentifier == null ? new CreateTx(this.networkConn, this, false, false, true) : new ModifyTx(this.networkConn, this, false, false, true);
            Provider.submit(tx);
        }

        public void processSdpOffer(byte[] paramArrayOfByte) throws SdpPortManagerException {
            NetworkConnectionImpl.this.checkState();
            if (paramArrayOfByte == null) {
                throw new SdpPortManagerException("The sdp argument passed cannot be null");
            }
            NetworkConnectionImpl.access$202(NetworkConnectionImpl.this, this.processCodecPolicy(new String(paramArrayOfByte)).getBytes());
            Runnable tx = NetworkConnectionImpl.this.connectionIdentifier == null ? new CreateTx(this.networkConn, this, true, false, false) : new ModifyTx(this.networkConn, this, true, false, false);
            Provider.submit(tx);
        }

        public void rejectSdpOffer() throws SdpPortManagerException {
            NetworkConnectionImpl.this.release();
        }

        public void setCodecPolicy(CodecPolicy paramCodecPolicy) throws SdpPortManagerException {
            this.codecPolicy = paramCodecPolicy;
        }

        public NetworkConnection getContainer() {
            return this.networkConn;
        }

        public boolean stop() {
            return false;
        }

        public void addListener(MediaEventListener<SdpPortManagerEvent> paramMediaEventListener) {
            NetworkConnectionImpl.this.eventListenerList.add(paramMediaEventListener);
        }

        public MediaSession getMediaSession() {
            return NetworkConnectionImpl.this.mediaSession;
        }

        public void removeListener(MediaEventListener<SdpPortManagerEvent> paramMediaEventListener) {
            NetworkConnectionImpl.this.eventListenerList.remove(paramMediaEventListener);
        }

        protected void update(SdpPortManagerEvent anEvent) {
            for (MediaEventListener<? extends MediaEvent<?>> mediaEventListener : NetworkConnectionImpl.this.eventListenerList) {
                EventExecutor exe = new EventExecutor(mediaEventListener, (MediaEvent)anEvent);
                Provider.submit(exe);
            }
        }

        private class ModifyTx
        implements Runnable,
        JainMgcpExtendedListener {
            private NetworkConnectionImpl networkConnectionImpl;
            private SdpPortManager sdpPortManager;
            private int tx = -1;
            private EventType eveType = null;

            public ModifyTx(NetworkConnectionImpl networkConnectionImpl, SdpPortManager sdpPortManager, boolean processSdpOffer, boolean generateSDPOffer, boolean processSdpAnswer) {
                this.networkConnectionImpl = networkConnectionImpl;
                this.sdpPortManager = sdpPortManager;
                this.eveType = processSdpOffer ? SdpPortManagerEvent.ANSWER_GENERATED : (generateSDPOffer ? SdpPortManagerEvent.OFFER_GENERATED : SdpPortManagerEvent.ANSWER_PROCESSED);
            }

            public void run() {
                try {
                    this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                    NetworkConnectionImpl.this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                    CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                    EndpointIdentifier endpointID = new EndpointIdentifier(NetworkConnectionImpl.this.endpoint, NetworkConnectionImpl.this.mgcpWrapper.getPeerIp() + ":" + NetworkConnectionImpl.this.mgcpWrapper.getPeerPort());
                    ModifyConnection modifyConnection = new ModifyConnection((Object)this, callId, endpointID, NetworkConnectionImpl.this.connectionIdentifier);
                    if (NetworkConnectionImpl.this.remoteSessionDescription != null) {
                        modifyConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(new String(NetworkConnectionImpl.this.remoteSessionDescription)));
                    }
                    modifyConnection.setTransactionHandle(this.tx);
                    modifyConnection.setNotifiedEntity(NetworkConnectionImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                    NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{modifyConnection});
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }

            public void transactionEnded(int arg0) {
            }

            public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            }

            public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
                logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
                NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
                SdpPortManagerEventImpl sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.TIMEOUT, "No response from MGW for modify");
                SdpPortManagerImpl.this.update(sdpEvent);
            }

            public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
            }

            public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
                switch (jainmgcpresponseevent.getObjectIdentifier()) {
                    case 206: {
                        this.processMofiyConnectionResponse((ModifyConnectionResponse)jainmgcpresponseevent);
                        break;
                    }
                    default: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                        logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                        SdpPortManagerEventImpl sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.UNKNOWN_ERROR, "modify failed. Look at logs " + jainmgcpresponseevent.getReturnCode().getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                    }
                }
            }

            private void processMofiyConnectionResponse(ModifyConnectionResponse responseEvent) {
                logger.debug((Object)" processMofiyConnectionResponse() ");
                SdpPortManagerEventImpl sdpEvent = null;
                ReturnCode returnCode = responseEvent.getReturnCode();
                switch (returnCode.getValue()) {
                    case 100: {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                        break;
                    }
                    case 200: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" MDCX TRANSACTION_EXECUTED_NORMALLY for connectionIdentifier = " + NetworkConnectionImpl.this.connectionIdentifier + "endpointID = " + NetworkConnectionImpl.this.endpoint));
                        }
                        if (responseEvent.getLocalConnectionDescriptor() != null) {
                            NetworkConnectionImpl.access$102(NetworkConnectionImpl.this, responseEvent.getLocalConnectionDescriptor().toString().getBytes());
                        }
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, NetworkConnectionImpl.this.localSessionDescription, true);
                        SdpPortManagerImpl.this.update(sdpEvent);
                        break;
                    }
                    case 502: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.RESOURCE_UNAVAILABLE, returnCode.getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                        break;
                    }
                    default: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.UNKNOWN_ERROR, returnCode.getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                    }
                }
            }
        }

        private class CreateTx
        implements Runnable,
        JainMgcpExtendedListener {
            private NetworkConnectionImpl networkConnectionImpl = null;
            private SdpPortManager sdpPortManager;
            private int tx = -1;
            private EventType eveType = null;

            public CreateTx(NetworkConnectionImpl networkConnectionImpl, SdpPortManager sdpPortManager, boolean processSdpOffer, boolean generateSDPOffer, boolean processSdpAnswer) {
                this.networkConnectionImpl = networkConnectionImpl;
                this.sdpPortManager = sdpPortManager;
                this.eveType = processSdpOffer ? SdpPortManagerEvent.ANSWER_GENERATED : (generateSDPOffer ? SdpPortManagerEvent.OFFER_GENERATED : SdpPortManagerEvent.ANSWER_PROCESSED);
            }

            public void run() {
                try {
                    this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                    NetworkConnectionImpl.this.mgcpWrapper.addListener(this.tx, (JainMgcpExtendedListener)this);
                    CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                    EndpointIdentifier endpointID = new EndpointIdentifier(NetworkConnectionImpl.this.endpoint, NetworkConnectionImpl.this.mgcpWrapper.getPeerIp() + ":" + NetworkConnectionImpl.this.mgcpWrapper.getPeerPort());
                    CreateConnection createConnection = new CreateConnection((Object)this, callId, endpointID, ConnectionMode.SendRecv);
                    if (NetworkConnectionImpl.this.remoteSessionDescription != null) {
                        createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(new String(NetworkConnectionImpl.this.remoteSessionDescription)));
                    }
                    createConnection.setTransactionHandle(this.tx);
                    createConnection.setNotifiedEntity(NetworkConnectionImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                    NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
                }
                catch (ConflictingParameterException e) {
                    logger.error((Object)e);
                }
            }

            public void transactionEnded(int arg0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully completed Tx = " + arg0));
                }
            }

            public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            }

            public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
                logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
                NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
                SdpPortManagerEventImpl sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.TIMEOUT, "No response from MGW for modify");
                SdpPortManagerImpl.this.update(sdpEvent);
            }

            public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
            }

            public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
                switch (jainmgcpresponseevent.getObjectIdentifier()) {
                    case 203: {
                        this.processCreateConnectionResponse((CreateConnectionResponse)jainmgcpresponseevent);
                        break;
                    }
                    default: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                        logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                        SdpPortManagerEventImpl sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.UNKNOWN_ERROR, "modify failed. Look at logs " + jainmgcpresponseevent.getReturnCode().getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                    }
                }
            }

            private void processCreateConnectionResponse(CreateConnectionResponse responseEvent) {
                logger.debug((Object)" processCreateConnectionResponse() ");
                SdpPortManagerEventImpl sdpEvent = null;
                ReturnCode returnCode = responseEvent.getReturnCode();
                switch (returnCode.getValue()) {
                    case 100: {
                        if (!logger.isDebugEnabled()) break;
                        logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                        break;
                    }
                    case 200: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        NetworkConnectionImpl.this.connectionIdentifier = responseEvent.getConnectionIdentifier();
                        NetworkConnectionImpl.this.endpoint = responseEvent.getSpecificEndpointIdentifier().getLocalEndpointName();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" TRANSACTION_EXECUTED_NORMALLY for connectionIdentifier = " + NetworkConnectionImpl.this.connectionIdentifier + " endpointID = " + NetworkConnectionImpl.this.endpoint));
                        }
                        NetworkConnectionImpl.access$102(NetworkConnectionImpl.this, responseEvent.getLocalConnectionDescriptor().toString().getBytes());
                        if (NetworkConnectionImpl.this.audioJoinableStream == null) {
                            NetworkConnectionImpl.this.audioJoinableStream = new AudioJoinableStream(this.networkConnectionImpl);
                        }
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, NetworkConnectionImpl.this.localSessionDescription, true);
                        SdpPortManagerImpl.this.update(sdpEvent);
                        break;
                    }
                    case 502: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.RESOURCE_UNAVAILABLE, returnCode.getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                        break;
                    }
                    case 527: {
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, SdpPortManagerEvent.SDP_NOT_ACCEPTABLE, returnCode.getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                        break;
                    }
                    default: {
                        logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                        NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                        sdpEvent = new SdpPortManagerEventImpl(this.sdpPortManager, this.eveType, null, false, MediaErr.UNKNOWN_ERROR, returnCode.getComment());
                        SdpPortManagerImpl.this.update(sdpEvent);
                    }
                }
            }
        }
    }
}

