/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jsr309.mgcp;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackProviderImpl;

public class MgcpStackFactory {
    private static final Logger logger = Logger.getLogger(MgcpStackFactory.class);
    private static MgcpStackFactory mgcpStackFactory;
    private ConcurrentHashMap<String, MgcpWrapper> stringToMgcpWrapper = new ConcurrentHashMap();
    public static final String MGCP_STACK_NAME = "mgcp.stack.name";
    public static final String MGCP_STACK_IP = "mgcp.stack.ip";
    public static final String MGCP_STACK_PORT = "mgcp.stack.port";
    public static final String MGCP_PEER_IP = "mgcp.stack.peer.ip";
    public static final String MGCP_PEER_PORT = "mgcp.stack.peer.port";

    private MgcpStackFactory() {
    }

    public static MgcpStackFactory getInstance() {
        if (mgcpStackFactory == null) {
            mgcpStackFactory = new MgcpStackFactory();
        }
        return mgcpStackFactory;
    }

    public MgcpWrapper getMgcpStackProvider(Properties properties) {
        MgcpWrapper mgcpWrapper;
        String stackName = "DEFAULT";
        if (properties != null) {
            stackName = properties.getProperty(MGCP_STACK_NAME, "DEFAULT");
        }
        if ((mgcpWrapper = this.stringToMgcpWrapper.get(stackName)) == null) {
            String ip = "127.0.0.1";
            String portString = "2727";
            String mgcpStackPeerIp = "127.0.0.1";
            int mgcpStackPeerPort = 2427;
            if (properties != null) {
                ip = properties.getProperty(MGCP_STACK_IP, "127.0.0.1");
                portString = properties.getProperty(MGCP_STACK_PORT, "2727");
                mgcpStackPeerIp = properties.getProperty(MGCP_PEER_IP, "127.0.0.1");
                mgcpStackPeerPort = Integer.parseInt(properties.getProperty(MGCP_PEER_PORT, "2427"));
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(ip);
                int port = Integer.parseInt(portString);
                JainMgcpStackImpl stack = new JainMgcpStackImpl(inetAddress, port);
                JainMgcpStackProviderImpl jainMgcpStackProviderImpl = (JainMgcpStackProviderImpl)stack.createProvider();
                if (properties != null) {
                    // empty if block
                }
                NotifiedEntity notifiedEntity = new NotifiedEntity(inetAddress.getHostName(), inetAddress.getHostAddress(), stack.getPort());
                mgcpWrapper = new MgcpWrapper(jainMgcpStackProviderImpl, notifiedEntity, mgcpStackPeerPort, mgcpStackPeerIp);
                jainMgcpStackProviderImpl.addJainMgcpListener((JainMgcpListener)mgcpWrapper);
                this.stringToMgcpWrapper.put(stackName, mgcpWrapper);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created new MgcpWrapper for MGCP_STACK_NAME = " + stackName));
                }
                return mgcpWrapper;
            }
            catch (UnknownHostException e) {
                logger.error((Object)e);
            }
            catch (CreateProviderException e) {
                logger.error((Object)e);
            }
            catch (TooManyListenersException e) {
                logger.error((Object)e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found JainMgcpStackProvider for MGCP_STACK_NAME = " + stackName));
            }
            return mgcpWrapper;
        }
        return null;
    }

    public void clearMgcpStackProvider(Properties properties) {
        MgcpWrapper mgcpWrapper;
        String stackName = "DEFAULT";
        if (properties != null) {
            stackName = properties.getProperty(MGCP_STACK_NAME, "DEFAULT");
        }
        if ((mgcpWrapper = this.stringToMgcpWrapper.get(stackName)) == null) {
            logger.warn((Object)("No JainMgcpStackProvider found for MGCP_STACK_NAME = " + stackName));
        } else {
            JainMgcpStackProviderImpl stackProvider = mgcpWrapper.getJainMgcpStackProvider();
            stackProvider.removeJainMgcpListener((JainMgcpListener)mgcpWrapper);
            JainMgcpStack mgcpStack = stackProvider.getJainMgcpStack();
            try {
                mgcpStack.deleteProvider((JainMgcpProvider)mgcpWrapper.getJainMgcpStackProvider());
                this.stringToMgcpWrapper.remove(stackName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully deleted JainMgcpStackProvider for MGCP_STACK_NAME = " + stackName));
                }
            }
            catch (DeleteProviderException e) {
                logger.error((Object)e);
            }
        }
    }
}

