package org.mobicents.javax.media.mscontrol.mixer;

import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.mixer.MixerAdapter;
import javax.media.mscontrol.mixer.MixerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;

import org.mobicents.javax.media.mscontrol.container.ContainerImpl;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.container.Endpoint;

/**
 * 
 * @author amit bhayani
 * 
 */
public class MediaMixerImpl extends ContainerImpl implements MediaMixer {

    public final static MediaConfig AUDIO_CONFIG = new MixerAudioConfig().getConfig();
    
    protected List<MixerAdapter> adaptors = new ArrayList<MixerAdapter>();
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> listeners = new CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>>();

    
    public MediaMixerImpl(MediaSessionImpl mediaSession, MediaConfigImpl config) throws MsControlException {
        super(mediaSession, config.getParameters());
        this.config = config;
        
        //determine endpoint local name
        String localName = (String)config.getValue(ENDPOINT_NAME);
        //domain name of the server is constructed using proprties from config
        String domainName = session.getDriver().getRemoteDomainName();
        
        //finally, the endpoint identifier is constructed
        endpoint = new Endpoint(new EndpointIdentifier(localName, domainName));
    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> config) throws MsControlException {
        if (config == null) {
            throw new MsControlException("Configuration is NULL");
        }
        
        
        MixerAdapterImpl adaptor = new MixerAdapterImpl(this,(MediaConfigImpl) config);
        adaptors.add(adaptor);
        return adaptor;

    }

    public MixerAdapter createMixerAdapter(Configuration<MixerAdapter> pattern, Parameters param)  throws MsControlException {
        if (config == null) {
            throw new MsControlException("Configuration can't be null");
        }
        
        MediaConfigImpl cfg = (MediaConfigImpl) getConfiguration(pattern).createCustomizedClone(param);

        MixerAdapterImpl adaptor = new MixerAdapterImpl(this,(MediaConfigImpl) cfg);
        adaptors.add(adaptor);
        return adaptor;
    }

    public MixerAdapter createMixerAdapter(MediaConfig config, Parameters params)  throws MsControlException {        
        if (config == null) {
            throw new MsControlException("MediaConfig cannot be null");
        }
        
        MediaConfig cfg = ((MediaConfigImpl)config).createCustomizedClone(params);

        MixerAdapterImpl adaptor = new MixerAdapterImpl(this,(MediaConfigImpl) cfg);
        adaptors.add(adaptor);
        return adaptor;
    }

    public void confirm() throws MsControlException {
        // TODO Auto-generated method stub
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> resource) throws MsControlException {
        // TODO Auto-generated method stub
        return null;
    }

    public void triggerRTC(Action rtca) {
        // TODO Auto-generated method stub
    }

    public void release() {
        try {
            unjoin();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(MediaEventListener<MixerEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MediaEventListener<MixerEvent> listener) {
        this.listeners.remove(listener);
    }

    public Iterator<MediaObject> getMediaObjects() {
        // TODO Auto-generated method stub
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        // TODO Auto-generated method stub
        return null;
    }

    public void addListener(AllocationEventListener paramAllocationEventListener) {
        // TODO Auto-generated method stub
    }

    public void removeListener(AllocationEventListener paramAllocationEventListener) {
        // TODO Auto-generated method stub
    }

    public void triggerAction(Action arg0) {
        // TODO Auto-generated method stub
    }
    
    public MediaConfig getConfiguration(Configuration pattern) {
        if (pattern.equals(MixerAdapter.DTMF_CLAMP)) {
            return MixerAdapterImpl.ADAPTOR_CFG;
        }
        return null;
    }
}
