/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.mscontrol.Configuration;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.vxml.VxmlDialog;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaObjectImpl;
import org.mobicents.javax.media.mscontrol.MsControlFactoryImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mixer.MediaMixerImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaSessionImpl
extends MediaObjectImpl
implements MediaSession {
    public static final int SESSION_TIMEOUT = 30000;
    private CallIdentifier callID = null;
    private List<NetworkConnection> connections = new ArrayList<NetworkConnection>();
    private List<MediaGroup> groups = new ArrayList<MediaGroup>();
    private List<MediaMixer> mixers = new ArrayList<MediaMixer>();
    private Map attributes = new HashMap();
    private final MsControlFactoryImpl factory;
    private static int reqID;

    public MediaSessionImpl(MsControlFactoryImpl factory) throws MsControlException {
        super(null, factory.getDriver(), null);
        this.factory = factory;
        this.callID = new CallIdentifier(this.genCallID());
    }

    public CallIdentifier getCallID() {
        return this.callID;
    }

    private String genCallID() {
        return Long.toHexString(System.nanoTime());
    }

    public synchronized int getUniqueHandler() {
        return this.factory.getUniqueHandler();
    }

    public synchronized int getUniqueReqID() {
        return ++reqID;
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> pattern) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = (MediaConfigImpl)this.factory.getMediaConfig(pattern);
        if (config == null) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        MediaGroupImpl group = new MediaGroupImpl(this, config);
        this.groups.add(group);
        return group;
    }

    public MediaGroup createMediaGroup(Configuration<MediaGroup> pattern, Parameters params) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = (MediaConfigImpl)this.factory.getMediaConfig(pattern);
        if (config == null) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        config = (MediaConfigImpl)config.createCustomizedClone(params);
        MediaGroupImpl group = new MediaGroupImpl(this, config);
        this.groups.add(group);
        return group;
    }

    public MediaGroup createMediaGroup(MediaConfig config, Parameters params) throws MsControlException {
        MediaGroupImpl group = new MediaGroupImpl(this, (MediaConfigImpl)config.createCustomizedClone(params));
        this.groups.add(group);
        return group;
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> pattern) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = (MediaConfigImpl)this.factory.getMediaConfig(pattern);
        if (config == null) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        MediaMixerImpl mixer = new MediaMixerImpl(this, config);
        this.mixers.add(mixer);
        return mixer;
    }

    public MediaMixer createMediaMixer(Configuration<MediaMixer> pattern, Parameters params) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = (MediaConfigImpl)this.factory.getMediaConfig(pattern);
        if (config == null) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        config = (MediaConfigImpl)config.createCustomizedClone(params);
        MediaMixerImpl mixer = new MediaMixerImpl(this, config);
        this.mixers.add(mixer);
        return mixer;
    }

    public MediaMixer createMediaMixer(MediaConfig config, Parameters params) throws MsControlException {
        MediaMixerImpl mixer = new MediaMixerImpl(this, (MediaConfigImpl)config.createCustomizedClone(params));
        this.mixers.add(mixer);
        return mixer;
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> pattern) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = null;
        if (pattern != NetworkConnection.BASIC) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        config = (MediaConfigImpl)NetworkConnectionImpl.BASE_CONFIG;
        NetworkConnectionImpl connection = new NetworkConnectionImpl(this, config);
        this.connections.add(connection);
        return connection;
    }

    public NetworkConnection createNetworkConnection(Configuration<NetworkConnection> pattern, Parameters params) throws MsControlException {
        if (pattern == null) {
            throw new MsControlException("Configuration is NULL");
        }
        MediaConfigImpl config = null;
        if (pattern != NetworkConnection.BASIC) {
            throw new MsControlException("Configuration is not supported: " + pattern);
        }
        config = (MediaConfigImpl)NetworkConnectionImpl.BASE_CONFIG;
        config = (MediaConfigImpl)config.createCustomizedClone(params);
        NetworkConnectionImpl connection = new NetworkConnectionImpl(this, config);
        this.connections.add(connection);
        return connection;
    }

    public NetworkConnection createNetworkConnection(MediaConfig config, Parameters params) throws MsControlException {
        return new NetworkConnectionImpl(this, (MediaConfigImpl)config.createCustomizedClone(params));
    }

    public VxmlDialog createVxmlDialog(Parameters paramParameters) throws MsControlException {
        throw new MsControlException("VxmlDialog is not yet supported");
    }

    public Object getAttribute(String paramString) {
        return this.attributes.get(paramString);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void removeAttribute(String paramString) {
        this.attributes.remove(paramString);
    }

    public void setAttribute(String paramString, Object paramObject) {
        this.attributes.put(paramString, paramObject);
    }

    public Iterator<MediaObject> getMediaObjects() {
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        return null;
    }

    public void release() {
        System.out.println(".... RELEASE SESSION COMMAND");
        for (MediaMixer mixer : this.mixers) {
            mixer.release();
        }
        for (MediaGroup group : this.groups) {
            group.release();
        }
        for (NetworkConnection connection : this.connections) {
            System.out.println("Releasing connection " + connection);
            connection.release();
        }
        this.factory.removeSession(this);
    }

    public void removeConnection(NetworkConnectionImpl connection) {
        this.connections.remove(connection);
    }

    public List<MediaGroup> getMedGrpList() {
        return this.groups;
    }

    public List<MediaMixer> getMedMxrList() {
        return this.mixers;
    }

    public MsControlFactoryImpl getMsControlFactoryImpl() {
        return this.factory;
    }

    @Override
    public String toString() {
        return this.getURI().toString();
    }
}

