/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.container;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.media.mscontrol.MsControlException;

public class InvocationLock {
    private Semaphore semaphore = new Semaphore(0);
    private long timestamp;

    public void lock(long timeout) throws MsControlException {
        this.timestamp = System.currentTimeMillis();
        try {
            this.semaphore.tryAcquire(1, timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new MsControlException("Interrupted");
        }
        long duration = System.currentTimeMillis() - this.timestamp;
        if (duration >= timeout) {
            throw new MsControlException("No response from server during " + timeout + " ms");
        }
    }

    public void release() {
        this.semaphore.release();
    }
}

