/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup.signals;

public class Options {
    private String prompt;
    private String[] segments;
    private int cursor;
    private int duration = -1;
    private int offset = 0;
    private int repeatCount;
    private int interval;
    private int mn;
    private String[] dp;
    private String dc;
    private int rc;
    private int pi = -1;
    private boolean ni = false;
    private long recordDuration = -1L;
    private String recordID;
    private boolean isOverride = true;
    private boolean silenceTermination = false;
    private long postSpeechTimer;
    private boolean clearDigits;

    public Options(String options) {
        if (options == null || options.length() == 0) {
            return;
        }
        String[] params = options.split(" ");
        for (int i = 0; i < params.length; ++i) {
            String[] tokens = params[i].trim().split("=");
            String param = tokens[0];
            String val = tokens[1];
            if (param.equalsIgnoreCase("an")) {
                this.segments = this.parseSegments(val);
            } else if (param.equalsIgnoreCase("du")) {
                this.duration = Integer.parseInt(val);
            } else if (param.equalsIgnoreCase("of")) {
                this.offset = Integer.parseInt(val);
            } else if (param.equalsIgnoreCase("it")) {
                this.repeatCount = Integer.parseInt(val);
            } else if (param.equalsIgnoreCase("iv")) {
                this.interval = Integer.parseInt(val);
            } else if (param.equalsIgnoreCase("ip")) {
                this.prompt = val;
            } else if (param.equalsIgnoreCase("mn")) {
                this.mn = Integer.parseInt(val);
            } else if (param.equalsIgnoreCase("dp")) {
                this.dp = val.split("|");
            } else if (param.equalsIgnoreCase("dc")) {
                this.dc = val;
            }
            if (param.equalsIgnoreCase("rc")) {
                this.rc = Integer.parseInt(val);
            }
            if (!param.equalsIgnoreCase("pi")) continue;
            this.pi = Integer.parseInt(val);
        }
    }

    public Options() {
    }

    public boolean hasMoreSegments() {
        return this.cursor < this.segments.length;
    }

    public String next() {
        return this.segments[this.cursor++];
    }

    private String[] parseSegments(String s) {
        if (s.startsWith("(")) {
            s = s.substring(1, s.length() - 1);
        }
        return s.split(";");
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getDigitsNumber() {
        return this.mn;
    }

    public void setDigitsNumber(int mn) {
        this.mn = mn;
    }

    public String[] getDigitPattern() {
        return this.dp;
    }

    public void setDigitPattern(String[] dp) {
        this.dp = dp;
    }

    public String getDigitsCollected() {
        return this.dc;
    }

    public int getReturnCode() {
        return this.rc;
    }

    public int getPatternIndex() {
        return this.pi;
    }

    public boolean isNonInterruptablePlay() {
        return this.ni;
    }

    public void setNonInterruptiblePlay(boolean ni) {
        this.ni = ni;
    }

    public void setRecordID(String recordID) {
        this.recordID = recordID;
    }

    public String getRecordID() {
        return this.recordID;
    }

    public void setRecordDuraion(long recordDuration) {
        this.recordDuration = recordDuration;
    }

    public long getRecordDuration() {
        return this.recordDuration;
    }

    public void setOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    public void setSilenceTermination(boolean val) {
        this.silenceTermination = val;
    }

    public void setPostSpeechTimer(long postSpeechTimer) {
        this.postSpeechTimer = postSpeechTimer;
    }

    public void setClearDigits(boolean val) {
        this.clearDigits = val;
    }

    public void processFilters(String[] filters) {
        if (filters == null) {
            return;
        }
        for (String filter : filters) {
            this.dc = this.dc.replaceAll(filter, "");
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.mn > 0) {
            buff.append("mn=").append(this.mn);
        }
        if (this.dp != null) {
            buff.append(" ");
            buff.append("dp=");
            for (int i = 0; i < this.dp.length - 1; ++i) {
                buff.append(this.dp[i]);
                if (i > this.dp.length - 2) continue;
                buff.append("|");
            }
            buff.append(this.dp[this.dp.length - 1]);
        }
        if (this.prompt != null) {
            buff.append(" ");
            buff.append("ip=");
            buff.append(this.prompt);
        }
        if (this.ni) {
            buff.append(" ");
            buff.append("ni=true");
        }
        if (this.recordDuration > 0L) {
            buff.append(" ");
            buff.append("rlt=").append(this.recordDuration);
        }
        if (this.recordID != null) {
            buff.append(" ");
            buff.append("ri=").append(this.recordID);
        }
        if (!this.isOverride) {
            buff.append(" ");
            buff.append("oa=false");
        }
        if (this.silenceTermination) {
            buff.append(" ");
            buff.append("pst=40");
        }
        if (this.postSpeechTimer > 0L) {
            buff.append(" ");
            buff.append("pst=").append(this.postSpeechTimer / 100L);
        }
        if (this.clearDigits) {
            buff.append(" ");
            buff.append("cb=true");
        }
        return buff.toString().trim();
    }
}

