/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.AllocationEventListener;
import org.mobicents.fsm.FSM;
import org.mobicents.fsm.Logger;
import org.mobicents.fsm.UnknownTransitionException;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.container.ContainerImpl;
import org.mobicents.javax.media.mscontrol.container.Endpoint;
import org.mobicents.javax.media.mscontrol.networkconnection.BaseConfig;
import org.mobicents.javax.media.mscontrol.networkconnection.CreateConnectionRequest;
import org.mobicents.javax.media.mscontrol.networkconnection.DeleteConnectionRequest;
import org.mobicents.javax.media.mscontrol.networkconnection.ModifyConnectionRequest;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpPortManagerEventImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpPortManagerImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.TimeoutError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkConnectionImpl
extends ContainerImpl
implements NetworkConnection,
Logger {
    public static final MediaConfig BASE_CONFIG = new BaseConfig().getConfig();
    protected SdpPortManagerImpl sdpPortManager = null;
    protected ConnectionIdentifier connectionID;
    private CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> listeners = new CopyOnWriteArrayList();
    protected FSM fsm;
    protected MediaErr error = MediaErr.NO_ERROR;
    protected String errorMsg;

    public NetworkConnectionImpl(MediaSessionImpl session, MediaConfigImpl config) throws MsControlException {
        super(session, config.getParameters());
        this.config = config;
        String localName = (String)config.getValue(ENDPOINT_NAME);
        String domainName = session.getDriver().getRemoteDomainName();
        this.endpoint = new Endpoint(new EndpointIdentifier(localName, domainName));
        this.maxJoinees = 1;
        this.sdpPortManager = new SdpPortManagerImpl(this);
        this.init();
    }

    protected void init() {
        this.fsm = new FSM(this.session.getDriver().getScheduler());
        this.fsm.setLogger(this);
        this.fsm.createState("NULL");
        this.fsm.createState("OPENING");
        this.fsm.createState("OPEN");
        this.fsm.createState("CANCELED");
        this.fsm.createState("HALF_OPEN");
        this.fsm.createState("MODIFYING");
        this.fsm.createState("CLOSING").setOnEnter(new DeleteConnectionRequest(this));
        this.fsm.createState("FAILED").setOnEnter(new SdpPortManagerEventImpl(this.sdpPortManager, SdpPortManagerEvent.NETWORK_STREAM_FAILURE));
        this.fsm.createState("INVALID");
        this.fsm.setStart("NULL");
        this.fsm.setEnd("INVALID");
        this.fsm.createTransition("crcx", "NULL", "OPENING").setHandler(new CreateConnectionRequest(this));
        this.fsm.createTransition("close", "NULL", "INVALID");
        this.fsm.createTransition("opened", "OPENING", "OPEN").setHandler(new SdpPortManagerEventImpl(this.sdpPortManager, SdpPortManagerEvent.ANSWER_GENERATED));
        this.fsm.createTransition("created", "OPENING", "HALF_OPEN").setHandler(new SdpPortManagerEventImpl(this.sdpPortManager, SdpPortManagerEvent.OFFER_GENERATED));
        this.fsm.createTransition("close", "OPENING", "CANCELED");
        this.fsm.createTransition("failure", "OPENING", "FAILED");
        this.fsm.createTimeoutTransition("OPENING", "FAILED", 5000L).setHandler(new TimeoutError(this));
        this.fsm.createTransition("close", "OPEN", "CLOSING");
        this.fsm.createTransition("modify", "HALF_OPEN", "MODIFYING").setHandler(new ModifyConnectionRequest(this));
        this.fsm.createTransition("close", "HALF_OPEN", "CLOSING");
        this.fsm.createTransition("opened", "MODIFYING", "OPEN").setHandler(new SdpPortManagerEventImpl(this.sdpPortManager, SdpPortManagerEvent.ANSWER_PROCESSED));
        this.fsm.createTransition("failure", "MODIFYING", "FAILED");
        this.fsm.createTransition("close", "MODIFYING", "CLOSING");
        this.fsm.createTimeoutTransition("MODIFYING", "FAILED", 5000L).setHandler(new TimeoutError(this));
        this.fsm.createTransition("opened", "CANCELED", "CLOSING");
        this.fsm.createTransition("created", "CANCELED", "CLOSING");
        this.fsm.createTimeoutTransition("CANCELED", "INVALID", 5000L);
        this.fsm.createTransition("closed", "CLOSING", "INVALID");
        this.fsm.createTransition("failure", "CLOSING", "INVALID");
        this.fsm.createTimeoutTransition("CLOSING", "INVALID", 5000L);
    }

    protected ConnectionIdentifier getConnectionID() {
        return this.connectionID;
    }

    protected void setConnectionID(ConnectionIdentifier connectionID) {
        this.connectionID = connectionID;
    }

    public SdpPortManager getSdpPortManager() throws MsControlException {
        return this.sdpPortManager;
    }

    public void confirm() throws MsControlException {
        throw new MsControlException("Operation not yet supported");
    }

    public MediaConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> paramClass) throws MsControlException {
        return null;
    }

    public void triggerRTC(Action paramAction) {
    }

    public Iterator<MediaObject> getMediaObjects() {
        return null;
    }

    public <T extends MediaObject> Iterator<T> getMediaObjects(Class<T> paramClass) {
        return null;
    }

    public void release() {
        this.info("Releasing....");
        try {
            this.unjoin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("State " + this.fsm.getState());
            this.fsm.signal("close");
        }
        catch (UnknownTransitionException e) {
            e.printStackTrace();
        }
    }

    public void addListener(AllocationEventListener listener) {
    }

    public void removeListener(AllocationEventListener listener) {
    }

    public void triggerAction(Action action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

