/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.networkconnection.CodecPolicy;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.SdpPortManager;
import javax.media.mscontrol.networkconnection.SdpPortManagerEvent;
import javax.media.mscontrol.networkconnection.SdpPortManagerException;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.mobicents.fsm.UnknownTransitionException;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.SdpPortManagerEventImpl;
import org.mobicents.mscontrol.sdp.AVProfile;
import org.mobicents.mscontrol.sdp.SessionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SdpPortManagerImpl
implements SdpPortManager {
    protected NetworkConnectionImpl connection;
    private SessionDescriptor localSdp;
    protected SessionDescriptor remoteSdp;
    private CopyOnWriteArrayList<MediaEventListener> listeners = new CopyOnWriteArrayList();
    private CodecPolicy codecPolicy = new CodecPolicy();

    public SdpPortManagerImpl(NetworkConnectionImpl connection) {
        this.connection = connection;
    }

    public synchronized void generateSdpOffer() throws SdpPortManagerException {
        if (this.connection.getEndpoint().concreteNameExpectedSoon()) {
            try {
                this.connection.getEndpoint().await();
            }
            catch (InterruptedException e) {
                throw new SdpPortManagerException(e.getMessage());
            }
        }
        this.connection.debug("Generating SDP offer");
        try {
            this.connection.fsm.signal("crcx");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public void processSdpOffer(byte[] sdp) throws SdpPortManagerException {
        if (this.connection.getEndpoint().concreteNameExpectedSoon()) {
            try {
                this.connection.getEndpoint().await();
            }
            catch (InterruptedException e) {
                throw new SdpPortManagerException(e.getMessage());
            }
        }
        if (!this.connection.getEndpoint().hasConcreteName()) {
            this.connection.getEndpoint().expectingConcreteName();
        }
        this.connection.debug("Processing SDP offer");
        this.remoteSdp = new SessionDescriptor(new String(sdp));
        for (String f : this.codecPolicy.getExcludedCodecs()) {
            this.remoteSdp.exclude(f);
        }
        try {
            this.connection.fsm.signal("crcx");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException("state= " + this.connection.fsm.getState().getName() + " transition: " + e.getMessage());
        }
    }

    public void processSdpAnswer(byte[] sdp) throws SdpPortManagerException {
        this.connection.debug("Processing SDP answer");
        this.remoteSdp = new SessionDescriptor(new String(sdp));
        try {
            this.connection.fsm.signal("modify");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public void rejectSdpOffer() throws SdpPortManagerException {
        try {
            this.connection.fsm.signal("close");
        }
        catch (UnknownTransitionException e) {
            throw new SdpPortManagerException(e.getMessage());
        }
    }

    public byte[] getMediaServerSessionDescription() throws SdpPortManagerException {
        return this.localSdp != null ? this.localSdp.toString().getBytes() : null;
    }

    public byte[] getUserAgentSessionDescription() throws SdpPortManagerException {
        return this.remoteSdp != null ? this.remoteSdp.toString().getBytes() : null;
    }

    public void setCodecPolicy(CodecPolicy codecPolicy) throws SdpPortManagerException {
        String[] excluded;
        String[] required;
        for (String codec : required = codecPolicy.getRequiredCodecs()) {
            if (!this.lookup(codec, codecPolicy.getExcludedCodecs())) continue;
            throw new SdpPortManagerException("Codec " + codec + " is excluded");
        }
        for (String codec : excluded = codecPolicy.getExcludedCodecs()) {
            if (this.lookup(codec, codecPolicy.getCodecCapabilities())) {
                throw new SdpPortManagerException("Codec " + codec + " is excluded but in capabilities");
            }
            if (!this.lookup(codec, codecPolicy.getCodecPreferences())) continue;
            throw new SdpPortManagerException("Codec " + codec + " is excluded but in preferences");
        }
        this.codecPolicy = codecPolicy;
    }

    private void print(String label, String[] list) {
        System.out.println(label);
        for (String s : list) {
            System.out.println(s);
        }
    }

    public CodecPolicy getCodecPolicy() {
        return this.codecPolicy;
    }

    public NetworkConnection getContainer() {
        return this.connection;
    }

    public void addListener(MediaEventListener<SdpPortManagerEvent> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MediaEventListener<SdpPortManagerEvent> listener) {
        this.listeners.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.connection.getMediaSession();
    }

    private boolean isSDPGenerated(SdpPortManagerEvent evt) {
        return evt.getEventType() == SdpPortManagerEvent.ANSWER_GENERATED || evt.getEventType() == SdpPortManagerEvent.OFFER_GENERATED;
    }

    private boolean applyCodecPolicy(SessionDescriptor sdp) {
        for (String f : this.codecPolicy.getRequiredCodecs()) {
            if (sdp.contains(f)) continue;
            if (f.equalsIgnoreCase("AMR")) {
                sdp.getMediaDescriptor(0).addFormat(99, AVProfile.AMR);
                this.connection.error = null;
                this.connection.errorMsg = "";
                return true;
            }
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        for (String f : this.codecPolicy.getCodecCapabilities()) {
            if (this.localSdp.contains(f)) continue;
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        for (String m : this.codecPolicy.getMediaTypeCapabilities()) {
            if (this.localSdp.containsMedia(m)) continue;
            this.connection.error = SdpPortManagerEvent.SDP_NOT_ACCEPTABLE;
            this.connection.errorMsg = "";
            return false;
        }
        return true;
    }

    protected void fireEvent(SdpPortManagerEvent evt) {
        if (this.isSDPGenerated(evt) && this.codecPolicy != null && !this.applyCodecPolicy(this.localSdp)) {
            this.fireEvent(new SdpPortManagerEventImpl(this, SdpPortManagerEvent.NETWORK_STREAM_FAILURE));
            try {
                this.connection.fsm.signal("close");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        new Thread(new EventProcessor(evt)).start();
    }

    private boolean lookup(String s, String[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return true;
        }
        return false;
    }

    protected void setLocalDescriptor(String sdp) throws SdpException {
        this.localSdp = new SessionDescriptor(sdp);
    }

    protected String getLocalDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    private String convertSDP(String sdpString) throws SdpException {
        SdpFactory factory = SdpFactory.getInstance();
        SessionDescription sd = factory.createSessionDescription(sdpString);
        Vector mediaDescriptions = sd.getMediaDescriptions(false);
        for (Object object : mediaDescriptions) {
            MediaDescription md = (MediaDescription)object;
            Vector attributes = md.getAttributes(false);
            for (Object object2 : attributes) {
                Attribute attribute = (Attribute)object2;
                if (attribute.getName().compareToIgnoreCase("rtpmap") != 0) continue;
                attribute.setValue(attribute.getValue().toUpperCase());
            }
        }
        return sd.toString();
    }

    private class EventProcessor
    implements Runnable {
        private SdpPortManagerEvent evt;

        public EventProcessor(SdpPortManagerEvent evt) {
            this.evt = evt;
        }

        public void run() {
            for (MediaEventListener listener : SdpPortManagerImpl.this.listeners) {
                SdpPortManagerImpl.this.connection.debug(String.format("Event=%s", this.evt.toString()));
                listener.onEvent((MediaEvent)this.evt);
            }
        }
    }

    private class Signal
    implements Runnable {
        private String t;

        public Signal(String t) {
            this.t = t;
            new Thread(this).start();
        }

        public void run() {
            try {
                SdpPortManagerImpl.this.connection.fsm.signal(this.t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

