/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.sdp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.mobicents.mscontrol.sdp.AudioFormat;
import org.mobicents.mscontrol.sdp.Format;
import org.mobicents.mscontrol.sdp.VideoFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVProfile
implements Cloneable {
    public static final String AUDIO = "audio";
    public static final String VIDEO = "video";
    public static final AudioFormat AMR = new AudioFormat("AMR", 8000.0, 8, 1);
    public static final AudioFormat PCMU = new AudioFormat("ULAW", 8000.0, 8, 1);
    public static final AudioFormat PCMA = new AudioFormat("ALAW", 8000.0, 8, 1);
    public static final AudioFormat SPEEX = new AudioFormat("SPEEX", 8000.0, -1, 1);
    public static final AudioFormat G729 = new AudioFormat("G729", 8000.0, -1, 1);
    public static final AudioFormat GSM = new AudioFormat("GSM", 8000.0, -1, 1);
    public static final AudioFormat MPEG4_GENERIC = new AudioFormat("mpeg4-generic", 8000.0, -1, 2);
    public static final AudioFormat L16_STEREO = new AudioFormat("LINEAR", 44100.0, 16, 2, 0, 1);
    public static final AudioFormat L16_MONO = new AudioFormat("LINEAR", 44100.0, 16, 1, 0, 1);
    public static final AudioFormat DTMF = new AudioFormat("telephone-event", 8000.0, -1, -1);
    public static final VideoFormat H261 = new VideoFormat("h261", 25.0f, 90000);
    public static final VideoFormat MP4V = new VideoFormat("MP4V-ES", 25.0f, 90000);
    public static final VideoFormat H263 = new VideoFormat("H263", 25.0f, 90000);
    private final HashMap<Integer, AudioFormat> audio = new HashMap();
    private final HashMap<Integer, VideoFormat> video = new HashMap();

    public AVProfile() {
        this.audio.put(0, PCMU);
        this.audio.put(8, PCMA);
        this.audio.put(99, AMR);
        this.audio.put(2, G729);
        this.audio.put(3, GSM);
        this.audio.put(16, L16_STEREO);
        this.audio.put(17, L16_MONO);
        this.audio.put(101, DTMF);
        this.video.put(45, H261);
        this.video.put(34, H263);
    }

    public void setProfile(Hashtable<Integer, Format> profile) {
        this.audio.clear();
        this.video.clear();
        Set<Integer> keys = profile.keySet();
        for (Integer key : keys) {
            Format f = profile.get(key);
            if (f instanceof AudioFormat) {
                this.audio.put(key, (AudioFormat)f);
                continue;
            }
            if (!(f instanceof VideoFormat)) continue;
            this.video.put(key, (VideoFormat)f);
        }
    }

    public Hashtable<Integer, Format> getProfile() {
        Hashtable<Integer, Format> profile = new Hashtable<Integer, Format>();
        profile.putAll(this.audio);
        profile.putAll(this.video);
        return profile;
    }

    public HashMap<Integer, AudioFormat> getAudioFormats() {
        return this.audio;
    }

    public HashMap<Integer, VideoFormat> getVideoFormats() {
        return this.video;
    }

    public AudioFormat getAudioFormat(int pt) {
        return this.audio.get(pt);
    }

    public VideoFormat getVideoFormat(int pt) {
        return this.video.get(pt);
    }

    public AVProfile clone() {
        AVProfile profile = new AVProfile();
        profile.setProfile(this.getProfile());
        return profile;
    }
}

