/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.sdp;

import org.mobicents.mscontrol.sdp.Format;
import org.mobicents.mscontrol.sdp.FormatUtils;

public class AudioFormat
extends Format {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 0;
    public static final int SIGNED = 1;
    public static final int UNSIGNED = 0;
    protected double sampleRate = -1.0;
    protected int sampleSizeInBits = -1;
    protected int channels = -1;
    protected int endian = -1;
    protected int signed = -1;
    protected int frameSizeInBits = -1;
    public static final String LINEAR = "LINEAR";
    public static final String ULAW = "ULAW";
    public static final String ALAW = "ALAW";
    public static final String SPEEX = "SPEEX";
    public static final String IMA4 = "ima4";
    public static final String IMA4_MS = "ima4/ms";
    public static final String MSADPCM = "msadpcm";
    public static final String DVI = "dvi";
    public static final String G723 = "g723";
    public static final String G728 = "g728";
    public static final String G729 = "G729";
    public static final String G729A = "g729a";
    public static final String GSM = "GSM";
    public static final String GSM_MS = "gsm/ms";
    public static final String MAC3 = "MAC3";
    public static final String MAC6 = "MAC6";
    public static final String TRUESPEECH = "truespeech";
    public static final String MSNAUDIO = "msnaudio";
    public static final String MPEGLAYER3 = "mpeglayer3";
    public static final String VOXWAREAC8 = "voxwareac8";
    public static final String VOXWAREAC10 = "voxwareac10";
    public static final String VOXWAREAC16 = "voxwareac16";
    public static final String VOXWAREAC20 = "voxwareac20";
    public static final String VOXWAREMETAVOICE = "voxwaremetavoice";
    public static final String VOXWAREMETASOUND = "voxwaremetasound";
    public static final String VOXWARERT29H = "voxwarert29h";
    public static final String VOXWAREVR12 = "voxwarevr12";
    public static final String VOXWAREVR18 = "voxwarevr18";
    public static final String VOXWARETQ40 = "voxwaretq40";
    public static final String VOXWARETQ60 = "voxwaretq60";
    public static final String MSRT24 = "msrt24";
    public static final String MPEG = "mpegaudio";
    public static final String DOLBYAC3 = "dolbyac3";
    public static final String AMR = "AMR";
    boolean init = false;
    private int hash;

    public AudioFormat(String encoding) {
        super(encoding);
        this.hash = encoding.hashCode();
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels) {
        super(encoding);
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.hash = encoding.hashCode() + (int)sampleRate + sampleSizeInBits + channels;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed) {
        super(encoding);
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.endian = endian;
        this.signed = signed;
        this.hash = encoding.hashCode() + (int)sampleRate + sampleSizeInBits + channels + endian + signed;
    }

    public AudioFormat(String encoding, double sampleRate, int sampleSizeInBits, int channels, int endian, int signed, int frameSizeInBits, double frameRate) {
        super(encoding);
        this.sampleRate = sampleRate;
        this.sampleSizeInBits = sampleSizeInBits;
        this.channels = channels;
        this.endian = endian;
        this.signed = signed;
        this.frameSizeInBits = frameSizeInBits;
        this.frameRate = (int)frameRate;
        this.hash = encoding.hashCode() + (int)sampleRate + sampleSizeInBits + channels + endian + signed;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getEndian() {
        return this.endian;
    }

    public int getSigned() {
        return this.signed;
    }

    public int getFrameSizeInBits() {
        return this.frameSizeInBits;
    }

    public String toString(boolean asInput) {
        StringBuffer b = new StringBuffer();
        b.append(this.encoding);
        if (FormatUtils.specified(this.sampleRate)) {
            b.append(", " + (int)this.sampleRate);
            if (!asInput) {
                b.append(" Hz");
            }
        } else if (!asInput) {
            b.append(", Unknown Sample Rate");
        }
        if (FormatUtils.specified(this.sampleSizeInBits)) {
            b.append(", ");
            b.append("" + this.sampleSizeInBits);
            if (!asInput) {
                b.append("-bit");
            }
        }
        if (FormatUtils.specified(this.channels)) {
            b.append(", ");
            if (!asInput) {
                if (this.channels == 1) {
                    b.append("Mono");
                } else if (this.channels == 2) {
                    b.append("Stereo");
                } else {
                    b.append("" + this.channels + "-channel");
                }
            } else {
                b.append("" + this.channels);
            }
        }
        if (FormatUtils.specified(this.endian) && FormatUtils.specified(this.sampleSizeInBits) && this.sampleSizeInBits > 8) {
            b.append(", ");
            if (!asInput) {
                if (this.endian == 1) {
                    b.append("BigEndian");
                } else if (this.endian == 0) {
                    b.append("LittleEndian");
                }
            } else {
                b.append("" + this.endian);
            }
        }
        if (FormatUtils.specified(this.signed)) {
            b.append(", ");
            if (!asInput) {
                if (this.signed != 1) {
                    b.append("Unsigned");
                } else {
                    b.append("Signed");
                }
            } else {
                b.append("" + this.signed);
            }
        }
        if (FormatUtils.specified(this.frameRate)) {
            b.append(", ");
            if (!asInput) {
                b.append("" + this.frameRate + " frame rate");
            } else {
                b.append("" + this.frameRate);
            }
        }
        if (FormatUtils.specified(this.frameSizeInBits)) {
            if (!asInput) {
                b.append(", FrameSize=" + this.frameSizeInBits + " bits");
            } else {
                b.append(", " + this.frameSizeInBits);
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public boolean equals(Object format) {
        return format.hashCode() == this.hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AudioFormat)) {
            boolean result = true;
            return true;
        }
        AudioFormat oCast = (AudioFormat)format;
        boolean result = FormatUtils.matches(this.sampleRate, oCast.sampleRate) && FormatUtils.matches(this.sampleSizeInBits, oCast.sampleSizeInBits) && FormatUtils.matches(this.channels, oCast.channels) && FormatUtils.matches(this.endian, oCast.endian) && FormatUtils.matches(this.signed, oCast.signed) && FormatUtils.matches(this.frameSizeInBits, oCast.frameSizeInBits) && FormatUtils.matches(this.frameRate, oCast.frameRate);
        return result;
    }

    public boolean matches(String encoding) {
        if (this.encoding.equals(ALAW) && encoding.equalsIgnoreCase("pcma")) {
            return true;
        }
        if (this.encoding.equals(ULAW) && encoding.equalsIgnoreCase("pcmu")) {
            return true;
        }
        return super.matches(encoding);
    }

    public Object clone() {
        return new AudioFormat(this.encoding, this.sampleRate, this.sampleSizeInBits, this.channels, this.endian, this.signed, this.frameSizeInBits, this.frameRate);
    }
}

