/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sdp;

import java.util.HashMap;
import org.mobicents.sdp.RTPAudioFormat;
import org.mobicents.sdp.RTPFormat;
import org.mobicents.sdp.RTPVideoFormat;

public abstract class AVProfile {
    public static final String AUDIO = "audio";
    public static final String VIDEO = "video";
    public static final RTPAudioFormat PCMU = new RTPAudioFormat(0, "ulaw", 8000.0, 8, 1);
    public static final RTPAudioFormat GSM = new RTPAudioFormat(3, "gsm", 8000.0, -1, 1);
    public static final RTPAudioFormat G723 = new RTPAudioFormat(4, "g723", 8000.0, -1, 1);
    public static final RTPAudioFormat DVI4_8K = new RTPAudioFormat(5, "dvi4", 8000.0, 4, 1);
    public static final RTPAudioFormat DVI4_16K = new RTPAudioFormat(6, "dvi4", 16000.0, 4, 1);
    public static final RTPAudioFormat LPC = new RTPAudioFormat(7, "lpc", 8000.0, -1, 1);
    public static final RTPAudioFormat PCMA = new RTPAudioFormat(8, "alaw", 8000.0, 8, 1);
    public static final RTPAudioFormat G722 = new RTPAudioFormat(9, "g722", 8000.0, 8, 1);
    public static final RTPAudioFormat L16_STEREO = new RTPAudioFormat(10, "LINEAR", 44100.0, 16, 2, 0, 1);
    public static final RTPAudioFormat L16_MONO = new RTPAudioFormat(11, "LINEAR", 44100.0, 16, 1, 0, 1);
    public static final RTPAudioFormat G729 = new RTPAudioFormat(18, "G729", 8000.0, -1, 1);
    public static final RTPAudioFormat SPEEX = new RTPAudioFormat(97, "speex", 8000.0, -1, 1);
    public static final RTPAudioFormat DTMF = new RTPAudioFormat(101, "telephone-event", 8000.0, -1, -1);
    public static final RTPVideoFormat H261 = new RTPVideoFormat(31, "h261", 90000.0f);
    private static final HashMap<Integer, RTPFormat> audioFormats = new HashMap();
    private static final HashMap<Integer, RTPFormat> videoFormats = new HashMap();

    public static RTPAudioFormat getAudioFormat(int pt) {
        return (RTPAudioFormat)audioFormats.get(pt);
    }

    public static RTPVideoFormat getVideoFormat(int pt) {
        return (RTPVideoFormat)videoFormats.get(pt);
    }

    static {
        audioFormats.put(PCMU.getPayloadType(), PCMU);
        audioFormats.put(GSM.getPayloadType(), GSM);
        audioFormats.put(G723.getPayloadType(), G723);
        audioFormats.put(DVI4_8K.getPayloadType(), DVI4_8K);
        audioFormats.put(DVI4_16K.getPayloadType(), DVI4_16K);
        audioFormats.put(LPC.getPayloadType(), LPC);
        audioFormats.put(PCMA.getPayloadType(), PCMA);
        audioFormats.put(G722.getPayloadType(), G722);
        audioFormats.put(SPEEX.getPayloadType(), SPEEX);
        audioFormats.put(G729.getPayloadType(), G729);
        audioFormats.put(L16_STEREO.getPayloadType(), L16_STEREO);
        audioFormats.put(L16_MONO.getPayloadType(), L16_MONO);
        videoFormats.put(H261.getPayloadType(), H261);
    }
}

