/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.sdp;

import java.util.Collection;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import org.mobicents.sdp.AVProfile;
import org.mobicents.sdp.AudioFormat;
import org.mobicents.sdp.RTPFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPAudioFormat
extends AudioFormat
implements RTPFormat {
    private int payloadType;
    private static final SdpFactory sdpFactory = SdpFactory.getInstance();

    public RTPAudioFormat(int payload, String encodingName) {
        super(encodingName);
        this.payloadType = payload;
    }

    public RTPAudioFormat(int payload, String encodingName, double sampleRate, int bits, int chans) {
        super(encodingName, sampleRate, bits, chans);
        this.payloadType = payload;
    }

    public RTPAudioFormat(int payload, String encodingName, double sampleRate, int bits, int chans, int endian, int signed) {
        super(encodingName, sampleRate, bits, chans, endian, signed);
        this.payloadType = payload;
    }

    @Override
    public int getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(int payload) {
        this.payloadType = payload;
    }

    public static RTPAudioFormat parseFormat(String encodingName) {
        if ((encodingName = encodingName.toLowerCase()).equals("pcmu")) {
            return AVProfile.PCMU;
        }
        if (encodingName.equals("g723")) {
            return AVProfile.G723;
        }
        if (encodingName.equals("pcma")) {
            return AVProfile.PCMA;
        }
        if (encodingName.equals("speex")) {
            return AVProfile.SPEEX;
        }
        if (encodingName.equals("telephone-event")) {
            return AVProfile.DTMF;
        }
        if (encodingName.equals("g729")) {
            return AVProfile.G729;
        }
        if (encodingName.equals("gsm")) {
            return AVProfile.GSM;
        }
        if (encodingName.equals("l16")) {
            return AVProfile.L16_MONO;
        }
        return null;
    }

    public static RTPAudioFormat parseRtpmapFormat(String rtpmap) {
        String[] tokens = rtpmap.toLowerCase().split(" ");
        int p = Integer.parseInt(tokens[0]);
        tokens = tokens[1].split("/");
        String encodingName = tokens[0];
        double clockRate = Double.parseDouble(tokens[1]);
        int chans = 1;
        if (tokens.length == 3) {
            chans = Integer.parseInt(tokens[2]);
        }
        if (encodingName.equals("pcmu")) {
            return new RTPAudioFormat(p, "ulaw", clockRate, 8, chans);
        }
        if (encodingName.equals("g723")) {
            return new RTPAudioFormat(p, "g723", clockRate, -1, chans);
        }
        if (encodingName.equals("pcma")) {
            return new RTPAudioFormat(p, "alaw", clockRate, 8, chans);
        }
        if (encodingName.equals("speex")) {
            return new RTPAudioFormat(p, "speex", clockRate, -1, chans);
        }
        if (encodingName.equals("telephone-event")) {
            return new RTPAudioFormat(p, "telephone-event", clockRate, -1, -1);
        }
        if (encodingName.equals("g729")) {
            return new RTPAudioFormat(p, "G729", clockRate, -1, chans);
        }
        if (encodingName.equals("gsm")) {
            return new RTPAudioFormat(p, "gsm", clockRate, -1, chans);
        }
        if (encodingName.equals("l16")) {
            return new RTPAudioFormat(p, "LINEAR", clockRate, 16, chans, 0, 1);
        }
        return new RTPAudioFormat(p, encodingName, clockRate, -1, chans);
    }

    @Override
    public Collection<Attribute> encode() {
        Vector<Attribute> list = new Vector<Attribute>();
        list.add(sdpFactory.createAttribute("rtpmap", this.toSdp()));
        if (this.getEncoding().equalsIgnoreCase("telephone-event")) {
            list.add(sdpFactory.createAttribute("fmtp", this.payloadType + " 0-15"));
        } else if (this.getEncoding().equalsIgnoreCase("g729")) {
            list.add(sdpFactory.createAttribute("fmtp", this.payloadType + " annex=b"));
        }
        return list;
    }

    public String toSdp() {
        String encName = this.getEncoding().toLowerCase();
        StringBuffer buff = new StringBuffer();
        buff.append(this.payloadType);
        buff.append(" ");
        if (encName.equals("alaw")) {
            buff.append("pcma");
        } else if (encName.equals("ulaw")) {
            buff.append("pcmu");
        } else if (encName.equals("linear")) {
            buff.append("l" + this.sampleSizeInBits);
        } else {
            buff.append(encName);
        }
        double sr = this.getSampleRate();
        if (sr > 0.0) {
            buff.append("/");
            if (sr - (double)((int)sr) < 1.0E-6) {
                buff.append((int)sr);
            } else {
                buff.append(sr);
            }
        }
        if (this.getChannels() > 1) {
            buff.append("/" + this.getChannels());
        }
        return buff.toString();
    }
}

