/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.parser.params;

import jain.protocol.ip.mgcp.message.parms.ResourceReservation;
import java.text.ParseException;

public class ResourceReservationHandler {
    public static ResourceReservation decode(byte[] value, int offset, int length) throws ParseException {
        if (length == 1) {
            if (value[offset] == 103 || value[offset] == 71) {
                return ResourceReservation.Guaranteed;
            }
        } else if (length == 2) {
            byte byte0 = value[offset];
            byte byte1 = value[offset + 1];
            switch (byte0) {
                case 67: 
                case 99: {
                    if (byte1 != 108 && byte1 != 76) break;
                    return ResourceReservation.ControlledLoad;
                }
                case 66: 
                case 98: {
                    if (byte1 != 101 && byte1 != 69) break;
                    return ResourceReservation.BestEffort;
                }
            }
        }
        throw new ParseException("Invalid value for Resource Reservation:" + new String(value, offset, length), 0);
    }

    public static int encode(byte[] destination, int offset, ResourceReservation resourceReservation) {
        StringBuffer s = new StringBuffer("");
        switch (resourceReservation.getResourceReservation()) {
            case 3: {
                destination[offset] = 98;
                destination[offset + 1] = 101;
                return 2;
            }
            case 2: {
                destination[offset] = 99;
                destination[offset + 1] = 108;
                return 2;
            }
            case 1: {
                destination[offset] = 103;
                return 1;
            }
        }
        return 0;
    }
}

