/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g711.ulaw;

import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Decoder
implements Codec {
    private static final Format ulaw = FormatFactory.createAudioFormat((String)"pcmu", (int)8000, (int)8, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private int j = 0;
    private int i = 0;
    private int sourceLen = 0;
    private int destinationLen = 0;
    private int currentIndex;
    private static byte[] muLawDecompressTable_low = new byte[]{-124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, -124, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, -60, 68, -60, 68, -60, 68, -60, 68, -60, 68, -60, 68, -60, 68, -60, 68, -92, -28, 36, 100, -92, -28, 36, 100, -92, -28, 36, 100, -92, -28, 36, 100, -108, -76, -44, -12, 20, 52, 84, 116, -108, -76, -44, -12, 20, 52, 84, 116, -116, -100, -84, -68, -52, -36, -20, -4, 12, 28, 44, 60, 76, 92, 108, 124, -120, -112, -104, -96, -88, -80, -72, -64, -56, -48, -40, -32, -24, -16, -8, 0, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, 124, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 60, -68, 60, -68, 60, -68, 60, -68, 60, -68, 60, -68, 60, -68, 60, -68, 92, 28, -36, -100, 92, 28, -36, -100, 92, 28, -36, -100, 92, 28, -36, -100, 108, 76, 44, 12, -20, -52, -84, -116, 108, 76, 44, 12, -20, -52, -84, -116, 116, 100, 84, 68, 52, 36, 20, 4, -12, -28, -44, -60, -76, -92, -108, -124, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0};
    private static byte[] muLawDecompressTable_high = new byte[]{-126, -122, -118, -114, -110, -106, -102, -98, -94, -90, -86, -82, -78, -74, -70, -66, -63, -61, -59, -57, -55, -53, -51, -49, -47, -45, -43, -41, -39, -37, -35, -33, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -16, -15, -15, -14, -14, -13, -13, -12, -12, -11, -11, -10, -10, -9, -9, -8, -8, -8, -7, -7, -7, -7, -6, -6, -6, -6, -5, -5, -5, -5, -4, -4, -4, -4, -4, -4, -3, -3, -3, -3, -3, -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 125, 121, 117, 113, 109, 105, 101, 97, 93, 89, 85, 81, 77, 73, 69, 65, 62, 60, 58, 56, 54, 52, 50, 48, 46, 44, 42, 40, 38, 36, 34, 32, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public Format getSupportedInputFormat() {
        return ulaw;
    }

    public Format getSupportedOutputFormat() {
        return linear;
    }

    public Frame process(Frame frame) {
        this.sourceLen = frame.getLength();
        this.destinationLen = this.sourceLen * 2;
        Frame res = Memory.allocate((int)this.destinationLen);
        byte[] data = frame.getData();
        byte[] resData = res.getData();
        this.i = 0;
        this.j = 0;
        while (this.i < this.sourceLen) {
            this.currentIndex = data[this.i] & 0xFF;
            resData[this.j++] = muLawDecompressTable_low[this.currentIndex];
            resData[this.j++] = muLawDecompressTable_high[this.currentIndex];
            ++this.i;
        }
        res.setOffset(0);
        res.setLength(this.destinationLen);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(linear);
        return res;
    }
}

