/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.gsm;

public class BasicFunctions {
    public static final short[] A = new short[]{20480, 20480, 20480, 20480, 13964, 15360, 8534, 9036};
    public static final short[] B = new short[]{0, 0, 2048, -2560, 94, -1792, -341, -1144};
    public static final short[] MIC = new short[]{-32, -32, -16, -16, -8, -8, -4, -4};
    public static final short[] MAC = new short[]{31, 31, 15, 15, 7, 7, 3, 3};
    public static final short[] INVA = new short[]{13107, 13107, 13107, 13107, 19223, 17476, 31454, 29708};
    public static final short[] DLB = new short[]{6554, 16384, 26214, Short.MAX_VALUE};
    public static final short[] QLB = new short[]{3277, 11469, 21299, Short.MAX_VALUE};
    public static final short[] H = new short[]{-134, -374, 0, 2054, 5741, 8192, 5741, 2054, 0, -374, -134};
    public static final short[] NRFAC = new short[]{29128, 26215, 23832, 21846, 20165, 18725, 17476, 16384};
    public static final short[] FAC = new short[]{18431, 20479, 22527, 24575, 26623, 28671, 30719, Short.MAX_VALUE};

    public static short checkOverflow(int value) {
        if (value < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        if (value > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)value;
    }

    public static int checkIntOverflow(long value) {
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static short add(short var1, short var2) {
        return BasicFunctions.checkOverflow(var1 + var2);
    }

    public static short sub(short var1, short var2) {
        return BasicFunctions.checkOverflow(var1 - var2);
    }

    public static short mult(short var1, short var2) {
        if (var1 == Short.MIN_VALUE && var2 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)(var1 * var2 >> 15);
    }

    public static short mult_r(short var1, short var2) {
        if (var1 == Short.MIN_VALUE && var2 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)(var1 * var2 + 16384 >> 15);
    }

    public static short abs(short var1) {
        if (var1 == Short.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        if (var1 < 0) {
            return -var1;
        }
        return var1;
    }

    public static short div(short var1, short var2) {
        if (var1 <= 0) {
            throw new ArithmeticException("Variable 1 should be positive");
        }
        if (var2 < var1) {
            throw new ArithmeticException("Variable 2 should be greater or equal to variable 1");
        }
        int value1 = var1;
        short value2 = var2;
        short result = 0;
        for (int i = 0; i < 15; ++i) {
            result = (short)(result << 1);
            if ((value1 <<= 1) < value2) continue;
            value1 = BasicFunctions.L_sub(value1, value2);
            result = BasicFunctions.add(result, (short)1);
        }
        return result;
    }

    public static int L_mult(short var1, short var2) {
        return var1 * var2 << 1;
    }

    public static int L_add(int var1, int var2) {
        return BasicFunctions.checkIntOverflow((long)var1 + (long)var2);
    }

    public static int L_sub(int var1, int var2) {
        return BasicFunctions.checkIntOverflow((long)var1 - (long)var2);
    }

    public static short norm(int var1) throws ArithmeticException {
        if (var1 == 0) {
            throw new ArithmeticException("Value can not be 0");
        }
        int currValue = var1;
        if (var1 < 0) {
            if (var1 <= -1073741824) {
                return 0;
            }
            currValue = ~(var1 - 1);
        }
        short count = -1;
        if (currValue >> 16 != 0) {
            currValue >>= 16;
        } else {
            count = (short)(count + 16);
        }
        if (currValue >> 8 != 0) {
            currValue >>= 8;
        } else {
            count = (short)(count + 8);
        }
        if (currValue >> 4 != 0) {
            currValue >>= 4;
        } else {
            count = (short)(count + 4);
        }
        if (currValue >> 2 != 0) {
            currValue >>= 2;
        } else {
            count = (short)(count + 2);
        }
        if (currValue >> 1 == 0) {
            count = (short)(count + 1);
        }
        return count;
    }
}

