/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component;

import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;

public class Dsp
implements Processor {
    private Codec codec;
    private Codec[] codecs;
    private Formats formats;
    private Format format;

    protected Dsp(Codec[] codecs) {
        this.codecs = codecs;
    }

    public Codec[] getCodecs() {
        return this.codecs;
    }

    public synchronized void setFormats(Formats formats) {
        this.formats = formats;
        this.format = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Frame process(Frame frame) {
        if (frame.getFormat() == null) {
            return frame;
        }
        if (this.format != null && frame.getFormat().matches(this.format)) {
            if (this.codec != null) {
                try {
                    Frame frame2 = this.codec.process(frame);
                    return frame2;
                }
                finally {
                    frame.recycle();
                }
            }
            return frame;
        }
        this.format = frame.getFormat();
        if (this.formats == null) {
            return frame;
        }
        if (this.formats.contains(this.format)) {
            this.codec = null;
            return frame;
        }
        this.codec = null;
        if (this.codecs == null) {
            return frame;
        }
        for (int i = 0; i < this.codecs.length; ++i) {
            if (!this.codecs[i].getSupportedInputFormat().matches(this.format) || !this.formats.contains(this.codecs[i].getSupportedOutputFormat())) continue;
            this.codec = this.codecs[i];
            break;
        }
        if (this.codec != null) {
            try {
                Frame frame3 = this.codec.process(frame);
                return frame3;
            }
            finally {
                frame.recycle();
            }
        }
        return frame;
    }
}

