/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component;

import org.mobicents.media.server.component.BufferListener;
import org.mobicents.media.server.spi.memory.Frame;

public class ElasticBuffer {
    private int delay;
    private int limit;
    private Frame[] buffer;
    private int rs;
    private int ro;
    private int ws;
    private int wo = -1;
    private Frame frame;
    private boolean isReady;
    private BufferListener listener;

    public ElasticBuffer(int delay, int limit) {
        this.delay = delay;
        this.limit = limit;
        this.buffer = new Frame[limit];
        this.isReady = false;
    }

    public void setListener(BufferListener listener) {
        this.listener = listener;
    }

    public synchronized void write(Frame frame) {
        this.updateWrite();
        if (this.wo == this.ro && this.isReady) {
            this.updateRead();
        }
        this.buffer[this.wo] = frame;
        if (!this.isReady && this.writeIndex() - this.readIndex() >= (long)this.delay) {
            this.isReady = true;
            if (this.listener != null) {
                this.listener.onReady();
            }
        }
    }

    public synchronized Frame read() {
        if (!this.isReady) {
            return null;
        }
        this.frame = this.buffer[this.ro];
        this.buffer[this.ro] = null;
        this.updateRead();
        if (this.readIndex() - 1L == this.writeIndex()) {
            this.isReady = false;
        }
        return this.frame;
    }

    private long readIndex() {
        return this.rs * this.limit + this.ro;
    }

    private long writeIndex() {
        return this.ws * this.limit + this.wo;
    }

    private void updateWrite() {
        ++this.wo;
        if (this.wo == this.limit) {
            this.wo = 0;
            ++this.ws;
        }
    }

    private void updateRead() {
        ++this.ro;
        if (this.ro == this.limit) {
            this.ro = 0;
            ++this.rs;
        }
    }

    public void clear() {
        this.ro = 0;
        this.rs = 0;
        this.wo = 0;
        this.ws = 0;
        this.isReady = false;
    }

    public boolean isEmpty() {
        return !this.isReady;
    }
}

