/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.component.Mixer;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class AudioMixer
implements Mixer {
    private static final int POOL_SIZE = 100;
    private Scheduler scheduler;
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private Formats formats = new Formats();
    private ArrayList<Input> pool = new ArrayList(100);
    private ArrayList<Input> inputs = new ArrayList(100);
    private final Output output;
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private Frame[] frames;
    private MixTask mixer;
    private volatile boolean started = false;
    protected long mixCount = 0L;

    public AudioMixer(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.formats.add((Format)this.format);
        this.mixer = new MixTask(scheduler);
        this.output = new Output(scheduler);
        for (int i = 0; i < 100; ++i) {
            this.pool.add(new Input(scheduler));
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = (AudioFormat)format;
        this.packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    }

    public synchronized MediaSink newInput() {
        Input input = this.pool.remove(0);
        input.buffer.clear();
        this.inputs.add(input);
        return input;
    }

    public MediaSource getOutput() {
        return this.output;
    }

    protected int getPacketSize() {
        return this.packetSize;
    }

    public synchronized void release(MediaSink input) {
        ((Input)input).recycle();
    }

    public synchronized void start() {
        this.startMixer();
    }

    public void startMixer() {
        if (!this.started) {
            this.started = true;
            this.output.buffer.clear();
            this.mixer.setDeadLine(this.scheduler.getClock().getTime() + 1L);
            this.scheduler.submit((Task)this.mixer);
            this.mixCount = 0L;
            for (Input input : this.inputs) {
                input.start();
            }
        }
    }

    public synchronized void stop() {
        this.stopMixer(true);
    }

    public void stopMixer(boolean stopOutput) {
        this.started = false;
        this.mixer.cancel();
        if (stopOutput) {
            this.output.stop();
        }
        for (Input input : this.inputs) {
            input.stop();
        }
    }

    public String report() {
        StringBuilder builder = new StringBuilder();
        builder.append("Mixer{\n");
        builder.append("     output:  (");
        builder.append(this.output.report());
        builder.append(")\n");
        for (Input input : this.inputs) {
            builder.append("     input: (");
            builder.append(input.report());
            builder.append(")\n");
        }
        builder.append("}");
        return builder.toString();
    }

    static /* synthetic */ Frame[] access$602(AudioMixer x0, Frame[] x1) {
        x0.frames = x1;
        return x1;
    }

    private class MixTask
    extends Task {
        private volatile long priority;
        private volatile long duration;

        public MixTask(Scheduler scheduler) {
            super(scheduler);
            this.duration = -100L;
        }

        public long getPriority() {
            return this.priority;
        }

        public void setPriority(long priority) {
            this.priority = priority;
        }

        public long getDuration() {
            return this.duration;
        }

        public long perform() {
            try {
                Frame frame = Memory.allocate((int)AudioMixer.this.packetSize);
                byte[] data = frame.getData();
                AudioMixer.access$602(AudioMixer.this, new Frame[AudioMixer.this.inputs.size()]);
                for (int i = 0; i < AudioMixer.this.frames.length; ++i) {
                    ((AudioMixer)AudioMixer.this).frames[i] = ((Input)AudioMixer.this.inputs.get(i)).poll();
                }
                int k = 0;
                for (int j = 0; j < AudioMixer.this.packetSize; j += 2) {
                    int s = 0;
                    for (int i = 0; i < AudioMixer.this.frames.length; ++i) {
                        if (AudioMixer.this.frames[i] == null) continue;
                        s = (short)(s + (short)(AudioMixer.this.frames[i].getData()[j + 1] << 8 | AudioMixer.this.frames[i].getData()[j] & 0xFF));
                    }
                    data[k++] = (byte)s;
                    data[k++] = (byte)(s >> 8);
                }
                for (int i = 0; i < AudioMixer.this.frames.length; ++i) {
                    if (AudioMixer.this.frames[i] == null) continue;
                    if (AudioMixer.this.frames[i].getHeader() != null) {
                        frame.setHeader(AudioMixer.this.frames[i].getHeader());
                    }
                    AudioMixer.this.frames[i].recycle();
                }
                frame.setOffset(0);
                frame.setLength(AudioMixer.this.packetSize);
                frame.setDuration(AudioMixer.this.period);
                frame.setFormat((Format)AudioMixer.this.format);
                AudioMixer.this.output.buffer.offer(frame);
                this.setDeadLine(this.getDeadLine() + AudioMixer.this.period);
                this.scheduler.submit((Task)this);
                AudioMixer.this.output.wakeup();
                ++AudioMixer.this.mixCount;
                return 0L;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0L;
            }
        }
    }

    private class Output
    extends AbstractSource {
        private ConcurrentLinkedQueue<Frame> buffer;

        public Output(Scheduler scheduler) {
            super("mixer.output", scheduler);
            this.buffer = new ConcurrentLinkedQueue();
        }

        public Frame evolve(long timestamp) {
            return this.buffer.poll();
        }

        public Formats getNativeFormats() {
            return AudioMixer.this.formats;
        }

        public void start() {
            AudioMixer.this.startMixer();
            super.start();
        }

        public void stop() {
            AudioMixer.this.stopMixer(false);
            super.stop();
        }
    }

    private class Input
    extends AbstractSink {
        private static final int limit = 50;
        private ConcurrentLinkedQueue<Frame> buffer;

        public Input(Scheduler scheduler) {
            super("mixer.input", scheduler);
            this.buffer = new ConcurrentLinkedQueue();
        }

        public void onMediaTransfer(Frame frame) throws IOException {
            if (this.buffer.size() < 50) {
                this.buffer.offer(frame);
            }
        }

        public Formats getNativeFormats() {
            return AudioMixer.this.formats;
        }

        protected boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        protected Frame poll() {
            return this.buffer.poll();
        }

        protected void recycle() {
            this.buffer.clear();
            AudioMixer.this.inputs.remove(this);
            AudioMixer.this.pool.add(this);
        }
    }
}

