/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Sine
extends AbstractSource {
    private static final AudioFormat LINEAR_AUDIO = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private static final Formats formats = new Formats();
    private volatile long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * LINEAR_AUDIO.getSampleRate() / 1000 * LINEAR_AUDIO.getSampleSize() / 8;
    private int f;
    private short A = Short.MAX_VALUE;
    private double dt = 1.0 / (double)LINEAR_AUDIO.getSampleRate();
    private double time;

    public Sine(Scheduler scheduler) {
        super("sine.generator", scheduler);
    }

    public void setAmplitude(short A) {
        this.A = A;
    }

    public short getAmplitude() {
        return this.A;
    }

    public void setFrequency(int f) {
        this.f = f;
    }

    public int getFrequency() {
        return this.f;
    }

    private short getValue(double t) {
        return (short)((double)this.A * Math.sin(Math.PI * 2 * (double)this.f * t));
    }

    public Frame evolve(long timestamp) {
        Frame frame = Memory.allocate((int)this.packetSize);
        int k = 0;
        int frameSize = this.packetSize / 2;
        byte[] data = frame.getData();
        for (int i = 0; i < frameSize; ++i) {
            short v = this.getValue(this.time + this.dt * (double)i);
            data[k++] = (byte)v;
            data[k++] = (byte)(v >> 8);
        }
        frame.setOffset(0);
        frame.setLength(this.packetSize);
        frame.setDuration(this.period);
        frame.setFormat((Format)LINEAR_AUDIO);
        this.time += (double)this.period / 1.0E9;
        return frame;
    }

    public Formats getNativeFormats() {
        return formats;
    }

    static {
        formats.add((Format)LINEAR_AUDIO);
    }
}

