/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.media.MediaSink;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.PipeImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.io.Pipe;
import org.mobicents.media.server.spi.memory.Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSink
extends BaseComponent
implements MediaSink {
    private volatile boolean started = false;
    private volatile boolean isSynchronized = false;
    private volatile long rxPackets;
    private volatile long rxBytes;
    private PipeImpl pipe;
    private final Scheduler scheduler;
    private final Worker worker;
    private final Transporter transporter;
    private Processor dsp;
    private final Formats formats = new Formats();
    private final Formats supportedFormats = new Formats();
    private ConcurrentLinkedQueue<Frame> buffer = new ConcurrentLinkedQueue();
    private Stats stats = new Stats();

    public AbstractSink(String name, Scheduler scheduler) {
        super(name);
        this.scheduler = scheduler;
        this.worker = new Worker(scheduler);
        this.transporter = new Transporter(scheduler);
        this.initFormats();
    }

    private void initFormats() {
        this.supportedFormats.clean();
        this.supportedFormats.addAll(this.getNativeFormats());
        this.formats.clean();
        this.formats.addAll(this.supportedFormats);
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
        this.rebuildFormats();
    }

    protected void rebuildFormats() {
        if (this.dsp == null) {
            this.initFormats();
            return;
        }
        this.supportedFormats.clean();
        Formats fmts = this.getNativeFormats();
        int fcount = fmts.size();
        for (int i = 0; i < fcount; ++i) {
            this.supportedFormats.add(fmts.get(i));
            for (Codec c : this.dsp.getCodecs()) {
                if (!c.getSupportedInputFormat().matches(fmts.get(i))) continue;
                this.supportedFormats.add(c.getSupportedOutputFormat());
            }
        }
        this.formats.clean();
        this.formats.addAll(this.formats);
        this.dsp.setFormats(this.formats);
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void setFormats(Formats formats) throws FormatNotSupportedException {
        this.supportedFormats.intersection(formats, this.formats);
        if (this.dsp != null) {
            this.dsp.setFormats(this.formats);
        }
    }

    public Formats getFormats() {
        return this.supportedFormats;
    }

    public void connect(Pipe pipe) {
        this.pipe = (PipeImpl)pipe;
        this.pipe.sink = this;
    }

    public void disconnect(Pipe pipe) {
        ((PipeImpl)pipe).sink = null;
        this.pipe = null;
    }

    public boolean isConnected() {
        return this.pipe != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract void onMediaTransfer(Frame var1) throws IOException;

    public abstract Formats getNativeFormats();

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.isSynchronized = true;
        this.rxBytes = 0L;
        this.rxPackets = 0L;
        this.worker.setDeadLine(this.scheduler.getClock().getTime() + 1L);
        this.scheduler.submit((Task)this.worker);
        this.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakeup() {
        Worker worker = this.worker;
        synchronized (worker) {
            if (!this.started) {
                return;
            }
            if (!this.isSynchronized) {
                this.isSynchronized = true;
                this.worker.setDeadLine(this.scheduler.getClock().getTime() + 1L);
                this.scheduler.submit((Task)this.worker);
            }
        }
    }

    public synchronized void stop() {
        this.started = false;
        this.worker.cancel();
        this.stopped();
    }

    protected void failed(Exception e) {
    }

    public long getPacketsReceived() {
        return this.rxPackets;
    }

    public long getBytesReceived() {
        return this.rxBytes;
    }

    @Override
    public void reset() {
        this.rxPackets = 0L;
        this.rxBytes = 0L;
        this.formats.clean();
        this.formats.addAll(this.supportedFormats);
    }

    protected void started() {
    }

    protected void stopped() {
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        return null;
    }

    public String report() {
        return this.stats.toString();
    }

    private class Stats {
        protected Format rxFormat;
        protected Format txFormat;

        private Stats() {
        }

        public String toString() {
            return "stream:" + this.rxFormat + ", codec: " + this.txFormat;
        }
    }

    private class Transporter
    extends Task {
        private Transporter(Scheduler scheduler) {
            super(scheduler);
        }

        public long getPriority() {
            return 0L;
        }

        public long getDuration() {
            return 0L;
        }

        public long perform() {
            if (AbstractSink.this.buffer.isEmpty()) {
                return 0L;
            }
            Frame frame = (Frame)AbstractSink.this.buffer.poll();
            AbstractSink.this.rxPackets++;
            AbstractSink.this.rxBytes += frame.getLength();
            try {
                AbstractSink.this.onMediaTransfer(frame);
            }
            catch (IOException e) {
                AbstractSink.this.started = false;
                AbstractSink.this.failed(e);
            }
            return 0L;
        }
    }

    private class Worker
    extends Task {
        public Worker(Scheduler scheduler) {
            super(scheduler);
        }

        public long getPriority() {
            return 0L;
        }

        public long getDuration() {
            return 0L;
        }

        public long perform() {
            if (AbstractSink.this.pipe == null) {
                AbstractSink.this.isSynchronized = false;
                return 0L;
            }
            Frame frame = AbstractSink.this.pipe.read();
            if (frame == null) {
                AbstractSink.this.isSynchronized = false;
                return 0L;
            }
            ((AbstractSink)AbstractSink.this).stats.rxFormat = frame.getFormat();
            if (AbstractSink.this.dsp != null) {
                frame = AbstractSink.this.dsp.process(frame);
            }
            ((AbstractSink)AbstractSink.this).stats.txFormat = frame.getFormat();
            AbstractSink.this.buffer.offer(frame);
            long frameDuration = frame.getDuration();
            AbstractSink.this.transporter.setDeadLine(this.scheduler.getClock().getTime() + frameDuration / 2L);
            this.scheduler.submit((Task)AbstractSink.this.transporter);
            if (frameDuration == 0L || frameDuration == Long.MAX_VALUE) {
                AbstractSink.this.isSynchronized = false;
                return 0L;
            }
            this.setDeadLine(this.getDeadLine() + frameDuration);
            this.scheduler.submit((Task)this);
            return 0L;
        }

        public String toString() {
            return AbstractSink.this.getName();
        }
    }
}

