/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.mobicents.media.server.component;

import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.spi.format.Format;

/**
 * Signal mixer.
 *
 * @author kulikov
 */
public interface Mixer {
    /**
     * The mixed output signal.
     *
     * @return media source transmitting mixed signal.
     */
    public MediaSource getOutput();

    /**
     * Creates new input signal.
     *
     * @return media sink receiving input signal.
     */
    public MediaSink newInput();

    /**
     * Disables specified input signal.
     *
     * @param input the sink receiving input signal.
     */
    public void release(MediaSink input);

    /**
     * Modify the intermediate format using for mixing.
     * 
     * @param format the format descriptor object
     */
    public void setFormat(Format format);

    /**
     * Gets the intermediate format used for mixing.
     *
     * @return the format descriptor object.
     */
    public Format getFormat();

    public void start();
    public void stop();
    
    public String report();
}
