/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;

public class Splitter {
    private static final int POOL_SIZE = 100;
    private final Input input;
    private ArrayList<Output> pool = new ArrayList(100);
    private ArrayList<Output> outputs = new ArrayList(100);
    private Formats formats = new Formats();

    public Splitter(Scheduler scheduler) {
        this.input = new Input(scheduler);
        for (int i = 0; i < 100; ++i) {
            this.pool.add(new Output(scheduler));
        }
    }

    public void setFormat(Format format) {
        this.formats.add(format);
        this.input.update();
        for (int i = 0; i < 100; ++i) {
            this.pool.get(i).update();
        }
    }

    public Format getFormat() {
        return this.formats.size() > 0 ? this.formats.get(0) : null;
    }

    public MediaSink getInput() {
        return this.input;
    }

    public MediaSource newOutput() {
        Output output = this.pool.remove(0);
        this.outputs.add(output);
        return output;
    }

    public void release(MediaSource output) {
        ((Output)output).recycle();
    }

    public String report() {
        StringBuilder builder = new StringBuilder();
        builder.append("Splitter{\n");
        builder.append("     input:  (");
        builder.append(this.input.report());
        builder.append(")\n");
        for (Output output : this.outputs) {
            builder.append("     output: (");
            builder.append(output.report());
            builder.append(")\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private class Output
    extends AbstractSource {
        private static final int limit = 50;
        private ConcurrentLinkedQueue<Frame> buffer;

        public Output(Scheduler scheduler) {
            super("splitter.output", scheduler);
            this.buffer = new ConcurrentLinkedQueue();
        }

        public Frame evolve(long timestamp) {
            return this.buffer.poll();
        }

        public Formats getNativeFormats() {
            return Splitter.this.formats;
        }

        protected void recycle() {
            this.buffer.clear();
            Splitter.this.outputs.remove(this);
            Splitter.this.pool.add(this);
        }

        private void update() {
            this.rebuildFormats();
        }
    }

    private class Input
    extends AbstractSink {
        public Input(Scheduler scheduler) {
            super("splitter.input", scheduler);
        }

        public void onMediaTransfer(Frame frame) throws IOException {
            for (Output output : Splitter.this.outputs) {
                if (output.buffer.size() >= 50) continue;
                output.buffer.offer(frame.clone());
                output.wakeup();
            }
            frame.recycle();
        }

        public Formats getNativeFormats() {
            return Splitter.this.formats;
        }

        private void update() {
            this.rebuildFormats();
        }
    }
}

