/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.BaseComponent;
import org.mobicents.media.server.impl.PipeImpl;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.io.Pipe;
import org.mobicents.media.server.spi.memory.Frame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSource
extends BaseComponent
implements MediaSource {
    private volatile long txPackets;
    private volatile long txBytes;
    private volatile boolean started;
    private volatile boolean isSynchronized;
    private volatile long timestamp = 0L;
    private long initialOffset;
    private long sn = 1L;
    protected long duration = -1L;
    private long initialDelay = 0L;
    private Scheduler scheduler;
    private final Worker worker;
    private final Transcoder transcoder;
    protected PipeImpl pipe;
    private Processor dsp;
    private final Formats formats = new Formats();
    private final Formats supportedFormats = new Formats();
    private ConcurrentLinkedQueue<Frame> buffer = new ConcurrentLinkedQueue();
    private Stats stats = new Stats();

    public AbstractSource(String name, Scheduler scheduler) {
        super(name);
        this.scheduler = scheduler;
        this.worker = new Worker(scheduler);
        this.transcoder = new Transcoder(scheduler);
        this.initFormats();
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    private void initFormats() {
        if (this.getNativeFormats().size() > 0) {
            this.supportedFormats.clean();
            this.supportedFormats.addAll(this.getNativeFormats());
        }
        this.formats.clean();
        this.formats.addAll(this.supportedFormats);
    }

    public long getMediaTime() {
        return this.timestamp;
    }

    public void setMediaTime(long timestamp) {
        this.initialOffset = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setDsp(Processor dsp) {
        this.dsp = dsp;
        this.rebuildFormats();
    }

    protected void rebuildFormats() {
        if (this.dsp == null) {
            this.initFormats();
            return;
        }
        Formats fmts = this.getNativeFormats();
        this.supportedFormats.clean();
        int fcount = fmts.size();
        for (int i = 0; i < fcount; ++i) {
            this.supportedFormats.add(fmts.get(i));
            for (Codec c : this.dsp.getCodecs()) {
                if (!c.getSupportedInputFormat().matches(fmts.get(i))) continue;
                this.supportedFormats.add(c.getSupportedOutputFormat());
            }
        }
        this.formats.clean();
        this.formats.addAll(this.supportedFormats);
        this.dsp.setFormats(this.formats);
    }

    public Processor getDsp() {
        return this.dsp;
    }

    public void setFormats(Formats formats) throws FormatNotSupportedException {
        this.supportedFormats.intersection(formats, this.formats);
        if (this.dsp != null) {
            this.dsp.setFormats(this.formats);
        }
    }

    public Formats getFormats() {
        return this.supportedFormats;
    }

    public synchronized void start() {
        try {
            if (this.started) {
                return;
            }
            if (this.scheduler == null) {
                throw new IllegalArgumentException("Scheduler is not assigned");
            }
            this.txBytes = 0L;
            this.txPackets = 0L;
            this.timestamp = this.initialOffset;
            this.initialOffset = 0L;
            this.sn = 0L;
            this.started = true;
            this.isSynchronized = true;
            this.worker.setDeadLine(this.scheduler.getClock().getTime() + this.initialDelay);
            this.scheduler.submit((Task)this.worker);
            this.initialDelay = 0L;
            this.started();
        }
        catch (Exception e) {
            this.started = false;
            this.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Worker worker = this.worker;
        synchronized (worker) {
            if (!this.started) {
                return;
            }
            if (!this.isSynchronized) {
                this.isSynchronized = true;
                this.worker.setDeadLine(this.scheduler.getClock().getTime() + 1L);
                this.scheduler.submit((Task)this.worker);
            }
        }
    }

    public void stop() {
        if (this.started) {
            this.stopped();
        }
        this.started = false;
        if (this.worker != null) {
            this.worker.cancel();
        }
        this.timestamp = 0L;
    }

    public void connect(Pipe pipe) {
        this.pipe = (PipeImpl)pipe;
        this.pipe.source = this;
    }

    public void disconnect(Pipe pipe) {
        if (this.pipe != pipe) {
            throw new IllegalArgumentException(pipe + " is not connected");
        }
        this.pipe.source = null;
        this.pipe = null;
    }

    public boolean isConnected() {
        return this.pipe != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract Frame evolve(long var1);

    public abstract Formats getNativeFormats();

    protected void started() {
    }

    protected void failed(Exception e) {
    }

    protected void completed() {
        this.started = false;
    }

    protected void stopped() {
    }

    public long getPacketsTransmitted() {
        return this.txPackets;
    }

    public long getBytesTransmitted() {
        return this.txBytes;
    }

    @Override
    public void reset() {
        this.txPackets = 0L;
        this.txBytes = 0L;
        this.formats.clean();
        this.formats.addAll(this.supportedFormats);
    }

    public String report() {
        return this.stats.toString();
    }

    @Override
    public <T> T getInterface(Class<T> interfaceType) {
        return null;
    }

    private class Stats {
        protected Format rxFormat;
        protected Format txFormat;

        private Stats() {
        }

        public String toString() {
            return "source: " + this.rxFormat + ", codec: " + this.txFormat;
        }
    }

    private class Transcoder
    extends Task {
        private Transcoder(Scheduler scheduler) {
            super(scheduler);
        }

        public long getPriority() {
            return 0L;
        }

        public long getDuration() {
            return 0L;
        }

        public long perform() {
            if (AbstractSource.this.buffer.isEmpty()) {
                return 0L;
            }
            Frame frame = (Frame)AbstractSource.this.buffer.poll();
            if (AbstractSource.this.dsp != null) {
                frame = AbstractSource.this.dsp.process(frame);
            }
            ((AbstractSource)AbstractSource.this).stats.txFormat = frame.getFormat();
            if (AbstractSource.this.pipe != null) {
                AbstractSource.this.pipe.write(frame);
            }
            AbstractSource.this.txPackets++;
            AbstractSource.this.txBytes += frame.getLength();
            return 0L;
        }
    }

    private class Worker
    extends Task {
        public Worker(Scheduler scheduler) {
            super(scheduler);
        }

        public long getPriority() {
            return 0L;
        }

        public long getDuration() {
            return AbstractSource.this.duration;
        }

        public long perform() {
            Frame frame = AbstractSource.this.evolve(AbstractSource.this.timestamp);
            if (frame == null) {
                AbstractSource.this.isSynchronized = false;
                return 0L;
            }
            frame.setTimestamp(AbstractSource.this.timestamp);
            frame.setSequenceNumber(AbstractSource.this.sn);
            AbstractSource.this.timestamp += frame.getDuration();
            AbstractSource.this.sn = AbstractSource.this.inc(AbstractSource.this.sn);
            if (AbstractSource.this.duration > 0L && AbstractSource.this.timestamp >= AbstractSource.this.duration) {
                frame.setEOM(true);
            }
            long frameDuration = frame.getDuration();
            AbstractSource.this.buffer.offer(frame);
            ((AbstractSource)AbstractSource.this).stats.rxFormat = frame.getFormat();
            AbstractSource.this.transcoder.setDeadLine(this.scheduler.getClock().getTime() + frameDuration / 2L);
            this.scheduler.submit((Task)AbstractSource.this.transcoder);
            if (frame.isEOM()) {
                AbstractSource.this.started = false;
                AbstractSource.this.completed();
                return -1L;
            }
            if (frameDuration <= 0L) {
                AbstractSource.this.isSynchronized = false;
                return 0L;
            }
            this.setDeadLine(this.getDeadLine() + frameDuration);
            this.scheduler.submit((Task)this);
            return 0L;
        }

        public String toString() {
            return AbstractSource.this.getName();
        }
    }
}

