/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.mobicents.media.MediaSink;
import org.mobicents.media.MediaSource;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.spi.io.Pipe;
import org.mobicents.media.server.spi.memory.Frame;

public class PipeImpl
implements Pipe {
    private static final int limit = 50;
    protected MediaSource source;
    protected MediaSink sink;
    private volatile ConcurrentLinkedQueue<Frame> buffer = new ConcurrentLinkedQueue();
    private int rxPackets;
    private int txPackets;
    private boolean isDebug;
    private long txTimestamp;

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    protected void write(Frame frame) {
        if (frame.getTimestamp() == this.txTimestamp && this.txTimestamp > 0L) {
            System.out.println("Drop packet");
            return;
        }
        if (this.isDebug) {
            System.out.print(frame.getTimestamp() + " ");
            this.dump(frame.getData(), frame.getOffset(), frame.getLength());
            System.out.println();
        }
        if (this.buffer.size() == 50) {
            this.buffer.poll();
        }
        this.buffer.offer(frame);
        this.txTimestamp = frame.getTimestamp();
        if (this.sink != null) {
            ((AbstractSink)this.sink).wakeup();
        }
        ++this.rxPackets;
    }

    protected Frame read() {
        ++this.txPackets;
        return this.buffer.poll();
    }

    public void connect(MediaSource source) {
        if (!(source instanceof AbstractSource)) {
            throw new IllegalArgumentException(source + " can not be connected");
        }
        source.connect((Pipe)this);
    }

    public void connect(MediaSink sink) {
        if (!(sink instanceof AbstractSink)) {
            throw new IllegalArgumentException(sink + " can not be connected");
        }
        sink.connect((Pipe)this);
    }

    public void disconnect(int termination) {
        if (termination == 1 && this.source != null) {
            this.source.disconnect((Pipe)this);
            return;
        }
        if (termination == 2 && this.sink != null) {
            this.sink.disconnect((Pipe)this);
            return;
        }
    }

    public void disconnect() {
        if (this.source != null) {
            this.source.disconnect((Pipe)this);
        }
        if (this.sink != null) {
            this.sink.disconnect((Pipe)this);
        }
    }

    public int size() {
        return this.buffer.size();
    }

    public void start() {
        if (this.source != null && this.sink != null) {
            this.buffer.clear();
            this.source.start();
            this.sink.start();
            this.rxPackets = 0;
            this.txPackets = 0;
        }
    }

    public void stop() {
        if (this.source != null && this.sink != null) {
            this.source.stop();
            this.sink.stop();
        }
    }

    public int getRxPackets() {
        return this.rxPackets;
    }

    public int getTxPackets() {
        return this.txPackets;
    }

    private void dump(byte[] data, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            System.out.print(data[i + offset] + " ");
        }
    }
}

