/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.util.Iterator;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class AudioComponent {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private ConcurrentMap<AudioInput> inputs = new ConcurrentMap();
    private ConcurrentMap<AudioOutput> outputs = new ConcurrentMap();
    private Iterator<AudioInput> activeInputs;
    private Iterator<AudioOutput> activeOutputs;
    protected Boolean shouldRead = false;
    protected Boolean shouldWrite = false;
    private int[] data;
    private byte[] dataArray;
    private Frame inputFrame;
    private Frame outputFrame;
    int inputCount;
    int outputCount;
    int inputIndex;
    int outputIndex;
    boolean first;
    private int componentId;

    public AudioComponent(int componentId) {
        this.packetSize = this.packetSize;
        this.componentId = componentId;
        this.data = new int[this.packetSize / 2];
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void updateMode(Boolean shouldRead, Boolean shouldWrite) {
        this.shouldRead = shouldRead;
        this.shouldWrite = shouldWrite;
    }

    public void addInput(AudioInput input) {
        this.inputs.put((Object)input.getInputId(), (Object)input);
    }

    public void addOutput(AudioOutput output) {
        this.outputs.put((Object)output.getOutputId(), (Object)output);
    }

    public void remove(AudioInput input) {
        this.inputs.remove((Object)input.getInputId());
    }

    public void remove(AudioOutput output) {
        this.outputs.remove((Object)output.getOutputId());
    }

    public void perform() {
        this.first = true;
        this.activeInputs = this.inputs.valuesIterator();
        while (this.activeInputs.hasNext()) {
            AudioInput input = this.activeInputs.next();
            this.inputFrame = input.poll();
            if (this.inputFrame == null) continue;
            this.dataArray = this.inputFrame.getData();
            if (this.first) {
                this.inputIndex = 0;
                this.inputCount = 0;
                while (this.inputCount < this.dataArray.length) {
                    this.data[this.inputIndex++] = (short)(this.dataArray[this.inputCount + 1] << 8 | this.dataArray[this.inputCount] & 0xFF);
                    this.inputCount += 2;
                }
                this.first = false;
            } else {
                this.inputIndex = 0;
                this.inputCount = 0;
                while (this.inputCount < this.dataArray.length) {
                    int n = this.inputIndex++;
                    this.data[n] = this.data[n] + (short)(this.dataArray[this.inputCount + 1] << 8 | this.dataArray[this.inputCount] & 0xFF);
                    this.inputCount += 2;
                }
            }
            this.inputFrame.recycle();
        }
    }

    public int[] getData() {
        if (!this.shouldRead.booleanValue()) {
            return null;
        }
        if (this.first) {
            return null;
        }
        return this.data;
    }

    public void offer(int[] data) {
        if (!this.shouldWrite.booleanValue()) {
            return;
        }
        this.outputFrame = Memory.allocate((int)this.packetSize);
        this.dataArray = this.outputFrame.getData();
        this.outputIndex = 0;
        this.outputCount = 0;
        while (this.outputCount < data.length) {
            this.dataArray[this.outputIndex++] = (byte)data[this.outputCount];
            this.dataArray[this.outputIndex++] = (byte)(data[this.outputCount++] >> 8);
        }
        this.outputFrame.setOffset(0);
        this.outputFrame.setLength(this.packetSize);
        this.outputFrame.setDuration(this.period);
        this.outputFrame.setFormat((Format)this.format);
        this.activeOutputs = this.outputs.valuesIterator();
        while (this.activeOutputs.hasNext()) {
            AudioOutput output = this.activeOutputs.next();
            if (!this.activeOutputs.hasNext()) {
                output.offer(this.outputFrame);
            } else {
                output.offer(this.outputFrame.clone());
            }
            output.wakeup();
        }
    }
}

