/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.io.IOException;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class AudioInput
extends AbstractSink {
    private int inputId;
    private int limit = 3;
    private ConcurrentCyclicFIFO<Frame> buffer = new ConcurrentCyclicFIFO();
    private Frame activeFrame = null;
    private byte[] activeData;
    private byte[] oldData;
    private int byteIndex = 0;
    private int count = 0;
    private int packetSize = 0;

    public AudioInput(int inputId, int packetSize) {
        super("compound.input");
        this.inputId = inputId;
        this.packetSize = packetSize;
    }

    public int getInputId() {
        return this.inputId;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        this.oldData = frame.getData();
        this.count = 0;
        while (this.count < this.oldData.length) {
            if (this.activeData == null) {
                this.activeFrame = Memory.allocate((int)this.packetSize);
                this.activeFrame.setOffset(0);
                this.activeFrame.setLength(this.packetSize);
                this.activeData = this.activeFrame.getData();
                this.byteIndex = 0;
            }
            if (this.oldData.length - this.count < this.activeData.length - this.byteIndex) {
                System.arraycopy(this.oldData, this.count, this.activeData, this.byteIndex, this.oldData.length - this.count);
                this.byteIndex += this.oldData.length - this.count;
                this.count = this.oldData.length;
                continue;
            }
            System.arraycopy(this.oldData, this.count, this.activeData, this.byteIndex, this.activeData.length - this.byteIndex);
            this.count += this.activeData.length - this.byteIndex;
            if (this.buffer.size() >= this.limit) {
                ((Frame)this.buffer.poll()).recycle();
            }
            this.buffer.offer((Object)this.activeFrame);
            this.activeFrame = null;
            this.activeData = null;
        }
        frame.recycle();
    }

    public boolean isEmpty() {
        return this.buffer.size() == 0;
    }

    public Frame poll() {
        return (Frame)this.buffer.poll();
    }

    public void recycle() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
        if (this.activeFrame != null) {
            this.activeFrame.recycle();
        }
        this.activeFrame = null;
        this.activeData = null;
        this.byteIndex = 0;
    }

    public void resetBuffer() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }
}

