/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.util.Iterator;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;

public class AudioMixer {
    private Scheduler scheduler;
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private ConcurrentMap<AudioComponent> components = new ConcurrentMap();
    Iterator<AudioComponent> activeComponents;
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private MixTask mixer;
    private volatile boolean started = false;
    public long mixCount = 0L;
    private double gain = 1.0;

    public AudioMixer(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.mixer = new MixTask();
    }

    public void addComponent(AudioComponent component) {
        this.components.put((Object)component.getComponentId(), (Object)component);
    }

    protected int getPacketSize() {
        return this.packetSize;
    }

    public void release(AudioComponent component) {
        this.components.remove((Object)component.getComponentId());
    }

    public void setGain(double gain) {
        this.gain = gain > 0.0 ? gain * 1.26 : (gain == 0.0 ? 1.0 : 1.0 / (gain * 1.26));
    }

    public void start() {
        this.mixCount = 0L;
        this.started = true;
        this.scheduler.submit((Task)this.mixer, Scheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started = false;
        this.mixer.cancel();
    }

    static /* synthetic */ int access$000(AudioMixer x0) {
        return x0.packetSize;
    }

    private class MixTask
    extends Task {
        int sourcesCount = 0;
        private int i;
        private int minValue = 0;
        private int maxValue = 0;
        private double currGain = 0.0;
        private int[] total = new int[AudioMixer.access$000(AudioMixer.this) / 2];
        private int[] current;

        public int getQueueNumber() {
            AudioMixer.this.scheduler;
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            AudioComponent component;
            this.sourcesCount = 0;
            AudioMixer.this.activeComponents = AudioMixer.this.components.valuesIterator();
            while (AudioMixer.this.activeComponents.hasNext()) {
                component = AudioMixer.this.activeComponents.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                if (this.sourcesCount == 0) {
                    System.arraycopy(this.current, 0, this.total, 0, this.total.length);
                } else {
                    this.i = 0;
                    while (this.i < this.total.length) {
                        int n = this.i;
                        this.total[n] = this.total[n] + this.current[this.i];
                        ++this.i;
                    }
                }
                ++this.sourcesCount;
            }
            if (this.sourcesCount == 0) {
                Scheduler scheduler = AudioMixer.this.scheduler;
                AudioMixer.this.scheduler;
                scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++AudioMixer.this.mixCount;
                return 0L;
            }
            this.minValue = 0;
            this.maxValue = 0;
            this.i = 0;
            while (this.i < this.total.length) {
                if (this.total[this.i] > this.maxValue) {
                    this.maxValue = this.total[this.i];
                } else if (this.total[this.i] < this.minValue) {
                    this.minValue = this.total[this.i];
                }
                ++this.i;
            }
            if (this.minValue > 0) {
                this.minValue = 0 - this.minValue;
            }
            if (this.minValue > this.maxValue) {
                this.maxValue = this.minValue;
            }
            this.currGain = AudioMixer.this.gain;
            if (this.maxValue > Short.MAX_VALUE) {
                this.currGain = this.currGain * 32767.0 / (double)this.maxValue;
            }
            this.i = 0;
            while (this.i < this.total.length) {
                this.total[this.i] = (short)((double)this.total[this.i] * this.currGain);
                ++this.i;
            }
            AudioMixer.this.activeComponents = AudioMixer.this.components.valuesIterator();
            while (AudioMixer.this.activeComponents.hasNext()) {
                component = AudioMixer.this.activeComponents.next();
                this.current = component.getData();
                if (this.current != null && this.sourcesCount > 1) {
                    this.i = 0;
                    while (this.i < this.total.length) {
                        this.current[this.i] = this.total[this.i] - (short)((double)this.current[this.i] * this.currGain);
                        ++this.i;
                    }
                    component.offer(this.current);
                    continue;
                }
                if (this.current != null) continue;
                component.offer(this.total);
            }
            Scheduler scheduler = AudioMixer.this.scheduler;
            AudioMixer.this.scheduler;
            scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++AudioMixer.this.mixCount;
            return 0L;
        }
    }
}

