/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.AbstractSource;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.memory.Frame;

public class AudioOutput
extends AbstractSource {
    private int outputId;
    private ConcurrentCyclicFIFO<Frame> buffer = new ConcurrentCyclicFIFO();

    public AudioOutput(Scheduler scheduler, int outputId) {
        super("compound.output", scheduler, Scheduler.OUTPUT_QUEUE);
        this.outputId = outputId;
    }

    public int getOutputId() {
        return this.outputId;
    }

    public void join(AbstractSink sink) {
        this.connect(sink);
    }

    public void unjoin() {
        this.disconnect();
    }

    public Frame evolve(long timestamp) {
        return (Frame)this.buffer.poll();
    }

    public void stop() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
        super.stop();
    }

    public void resetBuffer() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }

    public void offer(Frame frame) {
        if (this.buffer.size() > 1) {
            ((Frame)this.buffer.poll()).recycle();
        }
        this.buffer.offer((Object)frame);
    }
}

