/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.util.Iterator;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;

public class AudioSplitter {
    private Scheduler scheduler;
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private ConcurrentMap<AudioComponent> insideComponents = new ConcurrentMap();
    private ConcurrentMap<AudioComponent> outsideComponents = new ConcurrentMap();
    private Iterator<AudioComponent> insideRIterator;
    private Iterator<AudioComponent> insideSIterator;
    private Iterator<AudioComponent> outsideRIterator;
    private Iterator<AudioComponent> outsideSIterator;
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private InsideMixTask insideMixer;
    private OutsideMixTask outsideMixer;
    private volatile boolean started = false;
    protected long mixCount = 0L;
    private double gain = 1.0;

    public AudioSplitter(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.insideMixer = new InsideMixTask();
        this.outsideMixer = new OutsideMixTask();
    }

    public void addInsideComponent(AudioComponent component) {
        this.insideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    public void addOutsideComponent(AudioComponent component) {
        this.outsideComponents.put((Object)component.getComponentId(), (Object)component);
    }

    protected int getPacketSize() {
        return this.packetSize;
    }

    public void releaseInsideComponent(AudioComponent component) {
        this.insideComponents.remove((Object)component.getComponentId());
    }

    public void releaseOutsideComponent(AudioComponent component) {
        this.outsideComponents.remove((Object)component.getComponentId());
    }

    public void setGain(double gain) {
        this.gain = gain > 0.0 ? gain * 1.26 : (gain == 0.0 ? 1.0 : 1.0 / (gain * 1.26));
    }

    public void start() {
        this.mixCount = 0L;
        this.started = true;
        this.scheduler.submit((Task)this.insideMixer, Scheduler.MIXER_MIX_QUEUE);
        this.scheduler.submit((Task)this.outsideMixer, Scheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started = false;
        this.insideMixer.cancel();
        this.outsideMixer.cancel();
    }

    static /* synthetic */ int access$000(AudioSplitter x0) {
        return x0.packetSize;
    }

    private class OutsideMixTask
    extends Task {
        Boolean first = false;
        private int i;
        private int minValue = 0;
        private int maxValue = 0;
        private double currGain = 0.0;
        private int[] total = new int[AudioSplitter.access$000(AudioSplitter.this) / 2];
        private int[] current;

        public int getQueueNumber() {
            AudioSplitter.this.scheduler;
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            AudioComponent component;
            this.first = true;
            AudioSplitter.this.outsideRIterator = AudioSplitter.this.outsideComponents.valuesIterator();
            while (AudioSplitter.this.outsideRIterator.hasNext()) {
                component = (AudioComponent)AudioSplitter.this.outsideRIterator.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                if (this.first.booleanValue()) {
                    System.arraycopy(this.current, 0, this.total, 0, this.total.length);
                    this.first = false;
                    continue;
                }
                this.i = 0;
                while (this.i < this.total.length) {
                    int n = this.i;
                    this.total[n] = this.total[n] + this.current[this.i];
                    ++this.i;
                }
            }
            if (this.first.booleanValue()) {
                Scheduler scheduler = AudioSplitter.this.scheduler;
                AudioSplitter.this.scheduler;
                scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++AudioSplitter.this.mixCount;
                return 0L;
            }
            this.minValue = 0;
            this.maxValue = 0;
            this.i = 0;
            while (this.i < this.total.length) {
                if (this.total[this.i] > this.maxValue) {
                    this.maxValue = this.total[this.i];
                } else if (this.total[this.i] < this.minValue) {
                    this.minValue = this.total[this.i];
                }
                ++this.i;
            }
            this.minValue = 0 - this.minValue;
            if (this.minValue > this.maxValue) {
                this.maxValue = this.minValue;
            }
            this.currGain = AudioSplitter.this.gain;
            if (this.maxValue > Short.MAX_VALUE) {
                this.currGain = this.currGain * 32767.0 / (double)this.maxValue;
            }
            this.i = 0;
            while (this.i < this.total.length) {
                this.total[this.i] = (short)Math.round((double)this.total[this.i] * this.currGain);
                ++this.i;
            }
            AudioSplitter.this.insideSIterator = AudioSplitter.this.insideComponents.valuesIterator();
            while (AudioSplitter.this.insideSIterator.hasNext()) {
                component = (AudioComponent)AudioSplitter.this.insideSIterator.next();
                component.offer(this.total);
            }
            Scheduler scheduler = AudioSplitter.this.scheduler;
            AudioSplitter.this.scheduler;
            scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++AudioSplitter.this.mixCount;
            return 0L;
        }
    }

    private class InsideMixTask
    extends Task {
        Boolean first = false;
        private int i;
        private int minValue = 0;
        private int maxValue = 0;
        private double currGain = 0.0;
        private int[] total = new int[AudioSplitter.access$000(AudioSplitter.this) / 2];
        private int[] current;

        public int getQueueNumber() {
            AudioSplitter.this.scheduler;
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            AudioComponent component;
            this.first = true;
            AudioSplitter.this.insideRIterator = AudioSplitter.this.insideComponents.valuesIterator();
            while (AudioSplitter.this.insideRIterator.hasNext()) {
                component = (AudioComponent)AudioSplitter.this.insideRIterator.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                if (this.first.booleanValue()) {
                    System.arraycopy(this.current, 0, this.total, 0, this.total.length);
                    this.first = false;
                    continue;
                }
                this.i = 0;
                while (this.i < this.total.length) {
                    int n = this.i;
                    this.total[n] = this.total[n] + this.current[this.i];
                    ++this.i;
                }
            }
            if (this.first.booleanValue()) {
                Scheduler scheduler = AudioSplitter.this.scheduler;
                AudioSplitter.this.scheduler;
                scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++AudioSplitter.this.mixCount;
                return 0L;
            }
            this.minValue = 0;
            this.maxValue = 0;
            this.i = 0;
            while (this.i < this.total.length) {
                if (this.total[this.i] > this.maxValue) {
                    this.maxValue = this.total[this.i];
                } else if (this.total[this.i] < this.minValue) {
                    this.minValue = this.total[this.i];
                }
                ++this.i;
            }
            if (this.minValue > 0) {
                this.minValue = 0 - this.minValue;
            }
            if (this.minValue > this.maxValue) {
                this.maxValue = this.minValue;
            }
            this.currGain = AudioSplitter.this.gain;
            if (this.maxValue > Short.MAX_VALUE) {
                this.currGain = this.currGain * 32767.0 / (double)this.maxValue;
            }
            this.i = 0;
            while (this.i < this.total.length) {
                this.total[this.i] = (short)Math.round((double)this.total[this.i] * this.currGain);
                ++this.i;
            }
            AudioSplitter.this.outsideSIterator = AudioSplitter.this.outsideComponents.valuesIterator();
            while (AudioSplitter.this.outsideSIterator.hasNext()) {
                component = (AudioComponent)AudioSplitter.this.outsideSIterator.next();
                component.offer(this.total);
            }
            Scheduler scheduler = AudioSplitter.this.scheduler;
            AudioSplitter.this.scheduler;
            scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++AudioSplitter.this.mixCount;
            return 0L;
        }
    }
}

