/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;

public class SoundCard
extends AbstractSink {
    private static final org.mobicents.media.server.spi.format.AudioFormat LINEAR = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)8, (int)1);
    private static final Formats formats = new Formats();
    private static final AudioFormat.Encoding GSM_ENCODING = new AudioFormat.Encoding("GSM0610");
    private AudioOutput output;
    private boolean first;
    private SourceDataLine sourceDataLine = null;
    private AudioFormat audioFormat = null;
    private static final Logger logger;

    public SoundCard(Scheduler scheduler) {
        super("soundcard");
        this.output = new AudioOutput(scheduler, ComponentType.SOUND_CARD.getType());
        this.output.join(this);
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public void activate() {
        this.first = true;
        this.output.start();
    }

    public void deactivate() {
        this.output.stop();
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        System.out.println("Receive " + frame.getFormat() + ", len=" + frame.getLength() + ", header=" + frame.getHeader());
        if (this.first) {
            this.first = false;
            org.mobicents.media.server.spi.format.AudioFormat fmt = (org.mobicents.media.server.spi.format.AudioFormat)frame.getFormat();
            if (fmt == null) {
                return;
            }
            float sampleRate = fmt.getSampleRate();
            int sampleSizeInBits = fmt.getSampleSize();
            int channels = fmt.getChannels();
            int frameSize = fmt.getSampleSize() / 8;
            float frameRate = 1.0f;
            boolean bigEndian = false;
            AudioFormat.Encoding encoding = this.getEncoding(fmt.getName().toString());
            frameSize = channels == -1 || sampleSizeInBits == -1 ? -1 : (sampleSizeInBits + 7) / 8 * channels;
            this.audioFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, sampleRate, bigEndian);
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            try {
                this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
                this.sourceDataLine.open(this.audioFormat);
                this.sourceDataLine.start();
            }
            catch (Exception e) {
                this.stop();
                logger.error((Object)e);
            }
        }
        byte[] data = frame.getData();
        try {
            this.sourceDataLine.write(data, frame.getOffset(), frame.getLength());
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
        }
    }

    private AudioFormat.Encoding getEncoding(String encodingName) {
        if (encodingName.equalsIgnoreCase("pcma")) {
            return AudioFormat.Encoding.ALAW;
        }
        if (encodingName.equalsIgnoreCase("pcmu")) {
            return AudioFormat.Encoding.ULAW;
        }
        if (encodingName.equalsIgnoreCase("gsm")) {
            return GSM_ENCODING;
        }
        return AudioFormat.Encoding.PCM_SIGNED;
    }

    static {
        formats.add((Format)LINEAR);
        logger = Logger.getLogger(SoundCard.class);
    }
}

