/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.io.IOException;
import org.mobicents.media.server.concurrent.ConcurrentCyclicFIFO;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBInput
extends AbstractSink {
    private int inputId;
    private int limit = 10;
    private ConcurrentCyclicFIFO<Frame> buffer = new ConcurrentCyclicFIFO();

    public OOBInput(int inputId) {
        super("compound.input");
        this.inputId = inputId;
    }

    public int getInputId() {
        return this.inputId;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void onMediaTransfer(Frame frame) throws IOException {
        if (this.buffer.size() >= this.limit) {
            ((Frame)this.buffer.poll()).recycle();
        }
        this.buffer.offer((Object)frame);
    }

    public boolean isEmpty() {
        return this.buffer.size() == 0;
    }

    public Frame poll() {
        return (Frame)this.buffer.poll();
    }

    public void recycle() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }

    public void resetBuffer() {
        while (this.buffer.size() > 0) {
            ((Frame)this.buffer.poll()).recycle();
        }
    }
}

