/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.component.oob;

import java.util.Iterator;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.concurrent.ConcurrentMap;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.memory.Frame;

public class OOBMixer {
    private Scheduler scheduler;
    private ConcurrentMap<OOBComponent> components = new ConcurrentMap();
    Iterator<OOBComponent> activeComponents;
    private MixTask mixer;
    private volatile boolean started = false;
    public long mixCount = 0L;
    private double gain = 1.0;

    public OOBMixer(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.mixer = new MixTask();
    }

    public void addComponent(OOBComponent component) {
        this.components.put((Object)component.getComponentId(), (Object)component);
    }

    public void release(OOBComponent component) {
        this.components.remove((Object)component.getComponentId());
    }

    public void start() {
        this.mixCount = 0L;
        this.started = true;
        this.scheduler.submit((Task)this.mixer, Scheduler.MIXER_MIX_QUEUE);
    }

    public void stop() {
        this.started = false;
        this.mixer.cancel();
    }

    private class MixTask
    extends Task {
        int sourceComponent = 0;
        private Frame current;

        public int getQueueNumber() {
            OOBMixer.this.scheduler;
            return Scheduler.MIXER_MIX_QUEUE;
        }

        public long perform() {
            OOBComponent component;
            OOBMixer.this.activeComponents = OOBMixer.this.components.valuesIterator();
            while (OOBMixer.this.activeComponents.hasNext()) {
                component = OOBMixer.this.activeComponents.next();
                component.perform();
                this.current = component.getData();
                if (this.current == null) continue;
                this.sourceComponent = component.getComponentId();
                break;
            }
            if (this.current == null) {
                Scheduler scheduler = OOBMixer.this.scheduler;
                OOBMixer.this.scheduler;
                scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
                ++OOBMixer.this.mixCount;
                return 0L;
            }
            OOBMixer.this.activeComponents = OOBMixer.this.components.valuesIterator();
            while (OOBMixer.this.activeComponents.hasNext()) {
                component = OOBMixer.this.activeComponents.next();
                if (component.getComponentId() == this.sourceComponent) continue;
                component.offer(this.current.clone());
            }
            this.current.recycle();
            Scheduler scheduler = OOBMixer.this.scheduler;
            OOBMixer.this.scheduler;
            scheduler.submit((Task)this, Scheduler.MIXER_MIX_QUEUE);
            ++OOBMixer.this.mixCount;
            return 0L;
        }
    }
}

