/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentCyclicFIFO<E> {
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void insert(Node<E> x) {
        this.last.next = x;
        this.last = this.last.next;
    }

    private Node<E> extract() {
        Node<E> current = this.head;
        this.head = this.head.next;
        current.item = this.head.item;
        this.head.item = null;
        return current;
    }

    public ConcurrentCyclicFIFO() {
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    public int size() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        boolean shouldSignal = false;
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.insert(new Node<E>(e));
            shouldSignal = count.getAndIncrement() == 0;
        }
        finally {
            putLock.unlock();
        }
        if (shouldSignal) {
            this.signalNotEmpty();
        }
        return !shouldSignal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        Node<E> x;
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            try {
                while (count.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            x = this.extract();
            if (count.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        Object result = x.item;
        x.item = null;
        x.next = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        Node<E> x = null;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                x = this.extract();
                if (count.getAndDecrement() > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (x != null) {
            Object result = x.item;
            x.item = null;
            x.next = null;
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.putLock.lock();
        this.takeLock.lock();
        try {
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            this.count.set(0);
        }
        finally {
            this.takeLock.unlock();
            this.putLock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<E> {
        volatile E item;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }
}

