/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.controller.signal;

import java.util.ArrayList;
import org.mobicents.media.server.mgcp.controller.signal.EventAction;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.utils.Text;

public class Event {
    private Text name;
    private Text evtName = new Text();
    private Text actionName = new Text();
    private Text[] descriptor = new Text[]{this.evtName, this.actionName};
    private boolean isActive;
    private ArrayList<EventAction> actions = new ArrayList();
    private EventAction requestedAction;

    public Event(Text eventName) {
        this.name = eventName;
    }

    public Text getName() {
        return this.name;
    }

    public void add(EventAction action) {
        this.actions.add(action);
    }

    public boolean matches(Text eventDescriptor) {
        this.requestedAction = null;
        eventDescriptor.divide(new char[]{'(', ')'}, this.descriptor);
        this.evtName.trim();
        this.actionName.trim();
        this.isActive = this.evtName.equals((Object)this.name);
        if (!this.isActive) {
            return false;
        }
        for (EventAction a : this.actions) {
            if (!a.getName().equals((Object)this.actionName)) continue;
            this.requestedAction = a;
            break;
        }
        this.isActive = this.requestedAction != null;
        return this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void fire(Signal s, Text options) {
        if (this.isActive) {
            this.requestedAction.perform(s, this, options);
        }
    }

    public void reset() {
        this.isActive = false;
        this.requestedAction = null;
    }
}

