/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.message.MgcpMessage;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.utils.Text;

public class MgcpResponse
extends MgcpMessage {
    private int responseCode;
    private int txID;
    private Text responseString;
    private ArrayList<Parameter> parameters = new ArrayList(15);
    private int count;
    private boolean sdpDetected = false;
    private Text sdp;
    private Text msg = new Text();
    private static final Logger logger = Logger.getLogger(MgcpResponse.class);

    public MgcpResponse() {
        for (int i = 0; i < 15; ++i) {
            this.parameters.add(new Parameter());
        }
        this.count = 0;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int code) {
        this.responseCode = code;
    }

    public int getTxID() {
        return this.txID;
    }

    public void setTxID(int txID) {
        this.txID = txID;
    }

    public Text getResponseString() {
        return this.responseString;
    }

    public void setResponseString(Text text) {
        this.responseString = text;
    }

    public Parameter getParameter(Text key) {
        for (int i = 0; i < this.count; ++i) {
            if (!this.parameters.get(i).getKey().equals((Object)key)) continue;
            return this.parameters.get(i);
        }
        return null;
    }

    public void setParameter(Text key, Text value) {
        if (key.equals((Object)Parameter.SDP)) {
            this.sdp = value;
            return;
        }
        this.parameters.get(this.count).copy(key, value);
        ++this.count;
    }

    public void strain(byte[] buff, int offset, int len) {
        this.msg.strain(buff, offset, len);
        Text header = this.msg.nextLine();
        Iterator tokens = header.split(' ').iterator();
        int off = offset;
        int length = header.length();
        Text t = (Text)tokens.next();
        off += t.length();
        this.responseCode = t.toInteger();
        t = (Text)tokens.next();
        off += t.length();
        this.txID = t.toInteger();
        this.responseString = new Text();
        this.responseString.strain(buff, off += 2, length - off);
        this.count = 0;
        while (this.msg.hasMoreLines()) {
            if (this.sdpDetected) {
                this.sdp = new Text();
                this.msg.copyRemainder(this.sdp);
                this.parameters.get(this.count).copy(Parameter.SDP, this.sdp);
                ++this.count;
                return;
            }
            Text line = this.msg.nextLine();
            if (line.length() == 0) {
                this.sdpDetected = true;
                continue;
            }
            int subItemsCount = line.divide(':', this.parameters.get((int)this.count).param);
            if (subItemsCount != 2) continue;
            this.parameters.get(this.count).trim();
            ++this.count;
        }
    }

    protected void parse(byte[] buff, int offset, int len) {
        try {
            this.strain(buff, offset, len);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void write(ByteBuffer buffer) {
        buffer.clear();
        buffer.rewind();
        new Text(this.responseCode).write(buffer);
        buffer.put((byte)32);
        new Text(this.txID).write(buffer);
        buffer.put((byte)32);
        this.responseString.write(buffer);
        buffer.put((byte)10);
        for (int i = 0; i < this.count; ++i) {
            this.parameters.get(i).write(buffer);
        }
        if (this.sdp != null) {
            buffer.put((byte)10);
            this.sdp.write(buffer);
        }
        buffer.flip();
        buffer.rewind();
    }

    public void reset() {
        this.sdp = null;
    }

    public void clean() {
        this.sdp = null;
        this.sdpDetected = false;
        this.count = 0;
    }

    public String toString() {
        return this.responseCode + " (" + this.responseString + ")";
    }
}

