/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx;

import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.tx.ActionListener;
import org.mobicents.media.server.mgcp.tx.Transaction;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChain;
import org.mobicents.media.server.scheduler.TaskChainListener;
import org.mobicents.media.server.scheduler.TaskListener;

public class Action
implements TaskChainListener {
    protected ActionListener listener;
    private TaskChain actionHandler;
    private Task rollbackHandler;
    private Transaction tx;
    private MgcpEvent event;
    private RollbackListener rollbackListener = new RollbackListener();

    protected Action() {
    }

    protected void setEvent(MgcpEvent event) {
        this.event = event;
    }

    public MgcpEvent getEvent() {
        return this.event;
    }

    public void setActionHandler(TaskChain handler) {
        this.actionHandler = handler;
        this.actionHandler.setListener((TaskChainListener)this);
    }

    public void setRollbackHandler(Task handler) {
        this.rollbackHandler = handler;
        this.rollbackHandler.setListener((TaskListener)this.rollbackListener);
    }

    public void start(Transaction tx) {
        this.tx = tx;
        this.actionHandler.setListener((TaskChainListener)this);
        tx.scheduler().submit(this.actionHandler);
    }

    public void rollback() {
        if (this.rollbackHandler != null) {
            Scheduler scheduler = this.tx.scheduler();
            this.tx.scheduler();
            scheduler.submit(this.rollbackHandler, Scheduler.MANAGEMENT_QUEUE);
        } else {
            this.tx.onRollback();
        }
    }

    public void onTermination() {
        if (this.listener != null) {
            this.listener.onComplete();
        }
    }

    public void onException(Exception e) {
        if (this.listener != null) {
            this.listener.onFailure(e);
        }
    }

    protected Transaction transaction() {
        return this.tx;
    }

    private class RollbackListener
    implements TaskListener {
        private RollbackListener() {
        }

        public void onTerminate() {
            Action.this.tx.onRollback();
        }

        public void handlerError(Exception e) {
        }
    }
}

