/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpAppDefined;
import org.mobicents.media.server.impl.rtcp.RtcpBye;
import org.mobicents.media.server.impl.rtcp.RtcpReceptionReport;
import org.mobicents.media.server.impl.rtcp.RtcpSdes;
import org.mobicents.media.server.impl.rtcp.RtcpSenderReport;

public class RtcpPacket
implements Serializable {
    private static final Logger logger = Logger.getLogger(RtcpPacket.class);
    private RtcpSenderReport rtcpSenderReport = null;
    private RtcpReceptionReport rtcpReceptionReport = null;
    private RtcpSdes rtcpSdes = null;
    private RtcpBye rtcpBye = null;
    private RtcpAppDefined rtcpAppDefined = null;
    private int noOfPackets = 0;
    private int packetSize = 0;

    public RtcpPacket() {
    }

    public RtcpPacket(RtcpSenderReport rtcpSenderReport, RtcpReceptionReport rtcpReceptionReport, RtcpSdes rtcpSdes, RtcpBye rtcpBye, RtcpAppDefined rtcpAppDefined) {
        this.rtcpSenderReport = rtcpSenderReport;
        this.rtcpReceptionReport = rtcpReceptionReport;
        this.rtcpSdes = rtcpSdes;
        this.rtcpBye = rtcpBye;
        this.rtcpAppDefined = rtcpAppDefined;
    }

    public int decode(byte[] rawData, int offSet) {
        this.packetSize = rawData.length - offSet;
        block7: while (offSet < rawData.length) {
            int type = rawData[offSet + 1] & 0xFF;
            switch (type) {
                case 200: {
                    ++this.noOfPackets;
                    this.rtcpSenderReport = new RtcpSenderReport();
                    offSet = this.rtcpSenderReport.decode(rawData, offSet);
                    continue block7;
                }
                case 201: {
                    ++this.noOfPackets;
                    this.rtcpReceptionReport = new RtcpReceptionReport();
                    offSet = this.rtcpReceptionReport.decode(rawData, offSet);
                    continue block7;
                }
                case 202: {
                    ++this.noOfPackets;
                    this.rtcpSdes = new RtcpSdes();
                    offSet = this.rtcpSdes.decode(rawData, offSet);
                    continue block7;
                }
                case 204: {
                    ++this.noOfPackets;
                    this.rtcpAppDefined = new RtcpAppDefined();
                    offSet = this.rtcpAppDefined.decode(rawData, offSet);
                    continue block7;
                }
                case 203: {
                    ++this.noOfPackets;
                    this.rtcpBye = new RtcpBye();
                    offSet = this.rtcpBye.decode(rawData, offSet);
                    continue block7;
                }
            }
            logger.error((Object)("Received type = " + type + " RTCP Packet decoding falsed. offSet = " + offSet));
            offSet = rawData.length;
        }
        return offSet;
    }

    public int encode(byte[] rawData, int offSet) {
        if (this.rtcpSenderReport != null) {
            ++this.noOfPackets;
            offSet = this.rtcpSenderReport.encode(rawData, offSet);
        }
        if (this.rtcpReceptionReport != null) {
            ++this.noOfPackets;
            offSet = this.rtcpReceptionReport.encode(rawData, offSet);
        }
        if (this.rtcpSdes != null) {
            ++this.noOfPackets;
            offSet = this.rtcpSdes.encode(rawData, offSet);
        }
        if (this.rtcpAppDefined != null) {
            ++this.noOfPackets;
            offSet = this.rtcpAppDefined.encode(rawData, offSet);
        }
        if (this.rtcpBye != null) {
            ++this.noOfPackets;
            offSet = this.rtcpBye.encode(rawData, offSet);
        }
        return offSet;
    }

    public RtcpSenderReport getRtcpSenderReport() {
        return this.rtcpSenderReport;
    }

    public RtcpReceptionReport getRtcpReceptionReport() {
        return this.rtcpReceptionReport;
    }

    public RtcpSdes getRtcpSdes() {
        return this.rtcpSdes;
    }

    public RtcpBye getRtcpBye() {
        return this.rtcpBye;
    }

    public RtcpAppDefined getRtcpAppDefined() {
        return this.rtcpAppDefined;
    }

    public int getNoOfPackets() {
        return this.noOfPackets;
    }

    public int getPacketSize() {
        return this.packetSize;
    }
}

