/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpCommonHeader;
import org.mobicents.media.server.impl.rtcp.RtcpReceptionReportItem;

public class RtcpReceptionReport
extends RtcpCommonHeader {
    private long ssrc;
    private RtcpReceptionReportItem[] rtcpReceptionReports = new RtcpReceptionReportItem[31];

    protected RtcpReceptionReport() {
    }

    public RtcpReceptionReport(boolean padding, long ssrc) {
        super(padding, 201);
        this.ssrc = ssrc;
    }

    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        int tmpCount = 0;
        while (offSet - tmp < this.length) {
            RtcpReceptionReportItem rtcpReceptionReportItem = new RtcpReceptionReportItem();
            offSet = rtcpReceptionReportItem.decode(rawData, offSet);
            this.rtcpReceptionReports[tmpCount++] = rtcpReceptionReportItem;
        }
        return offSet;
    }

    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        for (RtcpReceptionReportItem rtcpReceptionReportItem : this.rtcpReceptionReports) {
            if (rtcpReceptionReportItem == null) break;
            offSet = rtcpReceptionReportItem.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public RtcpReceptionReportItem[] getRtcpReceptionReports() {
        return this.rtcpReceptionReports;
    }

    public void addRtcpReceptionReportItem(RtcpReceptionReportItem rtcpReceptionReportItem) {
        this.rtcpReceptionReports[this.count++] = rtcpReceptionReportItem;
    }
}

