/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpCommonHeader;
import org.mobicents.media.server.impl.rtcp.RtcpSdesChunk;

public class RtcpSdes
extends RtcpCommonHeader {
    private RtcpSdesChunk[] sdesChunks = new RtcpSdesChunk[31];

    protected RtcpSdes() {
    }

    public RtcpSdes(boolean padding) {
        super(padding, 202);
    }

    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        int tmpCount = 0;
        while (offSet - tmp < this.length) {
            RtcpSdesChunk rtcpSdesChunk = new RtcpSdesChunk();
            offSet = rtcpSdesChunk.decode(rawData, offSet);
            this.sdesChunks[tmpCount++] = rtcpSdesChunk;
        }
        return offSet;
    }

    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        for (RtcpSdesChunk rtcpSdesChunk : this.sdesChunks) {
            if (rtcpSdesChunk == null) break;
            offSet = rtcpSdesChunk.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public void addRtcpSdesChunk(RtcpSdesChunk rtcpSdesChunk) {
        this.sdesChunks[this.count++] = rtcpSdesChunk;
    }

    public RtcpSdesChunk[] getSdesChunks() {
        return this.sdesChunks;
    }
}

