/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpSdesItem;

public class RtcpSdesChunk {
    private long ssrc;
    private RtcpSdesItem[] rtcpSdesItems = new RtcpSdesItem[9];
    private int itemCount = 0;

    public RtcpSdesChunk(long ssrc) {
        this.ssrc = ssrc;
    }

    protected RtcpSdesChunk() {
    }

    protected int decode(byte[] rawData, int offSet) {
        RtcpSdesItem sdesItem;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        do {
            sdesItem = new RtcpSdesItem();
            offSet = sdesItem.decode(rawData, offSet);
            this.rtcpSdesItems[this.itemCount++] = sdesItem;
        } while (0 != sdesItem.getType());
        return offSet;
    }

    public void addRtcpSdesItem(RtcpSdesItem rtcpSdesItem) {
        this.rtcpSdesItems[this.itemCount++] = rtcpSdesItem;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public RtcpSdesItem[] getRtcpSdesItems() {
        return this.rtcpSdesItems;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    protected int encode(byte[] rawData, int offSet) {
        int temp = offSet;
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        for (RtcpSdesItem rtcpSdesItem : this.rtcpSdesItems) {
            if (rtcpSdesItem == null) break;
            offSet = rtcpSdesItem.encode(rawData, offSet);
        }
        rawData[offSet++] = 0;
        int remainder = (offSet - temp) % 4;
        if (remainder != 0) {
            int pad = 4 - remainder;
            for (int i = 0; i < pad; ++i) {
                rawData[offSet++] = 0;
            }
        }
        return offSet;
    }
}

