/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpCommonHeader;
import org.mobicents.media.server.impl.rtcp.RtcpReceptionReportItem;

public class RtcpSenderReport
extends RtcpCommonHeader {
    private long ssrc;
    private long ntpSec;
    private long ntpFrac;
    private long rtpTs;
    private long psent;
    private long osent;
    private RtcpReceptionReportItem[] rtcpReceptionReports = new RtcpReceptionReportItem[31];

    protected RtcpSenderReport() {
    }

    public RtcpSenderReport(boolean padding, long ssrc, long ntpSec, long ntpFrac, long rtpTs, long psent, long osent) {
        super(padding, 200);
        this.ssrc = ssrc;
        this.ntpSec = ntpSec;
        this.ntpFrac = ntpFrac;
        this.rtpTs = rtpTs;
        this.psent = psent;
        this.osent = osent;
    }

    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpSec <<= 8;
        this.ntpSec |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.ntpFrac <<= 8;
        this.ntpFrac |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.rtpTs <<= 8;
        this.rtpTs |= (long)(rawData[offSet++] & 0xFF);
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.psent <<= 8;
        this.psent |= (long)(rawData[offSet++] & 0xFF);
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        this.osent <<= 8;
        this.osent |= (long)(rawData[offSet++] & 0xFF);
        int tmpCount = 0;
        while (offSet - tmp < this.length) {
            RtcpReceptionReportItem rtcpReceptionReportItem = new RtcpReceptionReportItem();
            offSet = rtcpReceptionReportItem.decode(rawData, offSet);
            this.rtcpReceptionReports[tmpCount++] = rtcpReceptionReportItem;
        }
        return offSet;
    }

    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ntpSec & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ntpSec & 0xFFL);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ntpFrac & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ntpFrac & 0xFFL);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.rtpTs & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.rtpTs & 0xFFL);
        rawData[offSet++] = (byte)((this.psent & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.psent & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.psent & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.psent & 0xFFL);
        rawData[offSet++] = (byte)((this.osent & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.osent & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.osent & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.osent & 0xFFL);
        for (RtcpReceptionReportItem rtcpReceptionReportItem : this.rtcpReceptionReports) {
            if (rtcpReceptionReportItem == null) break;
            offSet = rtcpReceptionReportItem.encode(rawData, offSet);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public long getNtpSec() {
        return this.ntpSec;
    }

    public long getNtpFrac() {
        return this.ntpFrac;
    }

    public long getRtpTs() {
        return this.rtpTs;
    }

    public long getPsent() {
        return this.psent;
    }

    public long getOsent() {
        return this.osent;
    }

    public RtcpReceptionReportItem[] getRtcpReceptionReports() {
        return this.rtcpReceptionReports;
    }

    public void addRtcpReceptionReportItem(RtcpReceptionReportItem rtcpReceptionReportItem) {
        this.rtcpReceptionReports[this.count++] = rtcpReceptionReportItem;
    }
}

