/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.BufferListener;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class JitterBuffer
implements Serializable {
    private static final int QUEUE_SIZE = 10;
    private ArrayList<Frame> queue = new ArrayList(10);
    private RtpClock rtpClock;
    private long isn = -1L;
    private long jitterBufferSize;
    private long arrivalDeadLine = 0L;
    private long droppedInRaw = 0L;
    private int dropCount;
    private volatile long duration;
    private BufferListener listener;
    private volatile boolean ready;
    private long currentTransit = 0L;
    private long currentJitter = 0L;
    private RTPFormats rtpFormats = new RTPFormats();
    private RTPFormat format;
    private Boolean useBuffer = true;
    private static final Logger logger = Logger.getLogger(JitterBuffer.class);

    public JitterBuffer(RtpClock clock, int jitterBufferSize) {
        this.rtpClock = clock;
        this.jitterBufferSize = jitterBufferSize;
    }

    private void initJitter(RtpPacket firstPacket) {
        long arrival = this.rtpClock.getLocalRtpTime();
        long firstPacketTimestamp = firstPacket.getTimestamp();
        this.currentTransit = arrival - firstPacketTimestamp;
    }

    private void estimateJitter(RtpPacket newPacket) {
        long newPacketTimestamp;
        long arrival = this.rtpClock.getLocalRtpTime();
        long transit = arrival - (newPacketTimestamp = newPacket.getTimestamp());
        long d = transit - this.currentTransit;
        if (d < 0L) {
            d = -d;
        }
        this.currentTransit = transit;
        this.currentJitter += d - (this.currentJitter + 8L >> 4);
    }

    public long getEstimatedJitter() {
        long jitterEstimate = this.currentJitter >> 4;
        return jitterEstimate;
    }

    public void setFormats(RTPFormats rtpFormats) {
        this.rtpFormats = rtpFormats;
    }

    public double getJitter() {
        return 0.0;
    }

    public double getMaxJitter() {
        return 0.0;
    }

    public int getDropped() {
        return this.dropCount;
    }

    public boolean bufferInUse() {
        return this.useBuffer;
    }

    public void setBufferInUse(boolean useBuffer) {
        this.useBuffer = useBuffer;
    }

    public void setListener(BufferListener listener) {
        this.listener = listener;
    }

    public void write(RtpPacket packet, RTPFormat format) {
        if (format == null) {
            return;
        }
        if (this.format == null || this.format.getID() != format.getID()) {
            this.format = format;
            logger.info((Object)("Format has been changed: " + this.format.toString()));
        }
        if (this.isn == -1L) {
            this.rtpClock.synchronize(packet.getTimestamp());
            this.isn = packet.getSeqNumber();
            this.initJitter(packet);
        } else {
            this.estimateJitter(packet);
        }
        this.rtpClock.setClockRate(this.format.getClockRate());
        Frame f = null;
        if (packet.getTimestamp() < this.arrivalDeadLine) {
            System.out.println("drop packet: dead line=" + this.arrivalDeadLine + ", packet time=" + packet.getTimestamp() + ", seq=" + packet.getSeqNumber() + ", payload length=" + packet.getPayloadLength() + ", format=" + this.format.toString());
            ++this.dropCount;
            ++this.droppedInRaw;
            if (this.droppedInRaw == 5L || this.queue.size() == 0) {
                this.arrivalDeadLine = 0L;
            } else {
                return;
            }
        }
        f = Memory.allocate((int)packet.getPayloadLength());
        f.setHeader(null);
        f.setSequenceNumber((long)packet.getSeqNumber());
        f.setTimestamp(this.rtpClock.convertToAbsoluteTime(packet.getTimestamp()));
        f.setOffset(0);
        f.setLength(packet.getPayloadLength());
        packet.getPyalod(f.getData(), 0);
        f.setFormat(this.format.getFormat());
        if (f != null) {
            int currIndex;
            this.droppedInRaw = 0L;
            for (currIndex = this.queue.size() - 1; currIndex >= 0 && this.queue.get(currIndex).getTimestamp() > f.getTimestamp(); --currIndex) {
            }
            if (currIndex >= 0 && this.queue.get(currIndex).getSequenceNumber() == f.getSequenceNumber()) {
                return;
            }
            this.queue.add(currIndex + 1, f);
            this.duration = 0L;
            if (this.queue.size() > 1) {
                this.duration = this.queue.get(this.queue.size() - 1).getTimestamp() - this.queue.get(0).getTimestamp();
            }
            for (int i = 0; i < this.queue.size() - 1; ++i) {
                long d = this.queue.get(i + 1).getTimestamp() - this.queue.get(i).getTimestamp();
                if (d > 0L) {
                    this.queue.get(i).setDuration(d);
                    continue;
                }
                this.queue.get(i).setDuration(0L);
            }
            if (this.duration < 0L && this.queue.size() > 1) {
                this.reset();
                return;
            }
            if (this.queue.size() > 10) {
                ++this.dropCount;
                this.queue.remove(0).recycle();
            }
            if (!this.ready) {
                boolean bl = this.ready = this.useBuffer == false || this.duration >= this.jitterBufferSize && this.queue.size() > 1;
                if (this.ready && this.listener != null) {
                    this.listener.onFill();
                }
            }
        }
    }

    public Frame read(long timestamp) {
        if (this.queue.size() == 0) {
            this.ready = false;
            return null;
        }
        Frame frame = this.queue.remove(0);
        if (this.queue.size() == 0) {
            this.ready = false;
            frame.setDuration(1L);
        }
        this.arrivalDeadLine = this.rtpClock.convertToRtpTime(frame.getTimestamp() + frame.getDuration());
        frame.setDuration(frame.getDuration() * 1000000L);
        frame.setTimestamp(frame.getTimestamp() * 1000000L);
        return frame;
    }

    public void reset() {
        while (this.queue.size() > 0) {
            this.queue.remove(0).recycle();
        }
    }

    public void restart() {
        this.reset();
        this.ready = false;
        this.arrivalDeadLine = 0L;
        this.dropCount = 0;
        this.droppedInRaw = 0L;
        this.format = null;
        this.isn = -1L;
    }
}

